
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/utility/naming/directory/NAttributes.java $
  $Revision: 3 $
  $Modtime: 8/10/99 5:47p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.utility.naming.directory;


import java.util.Enumeration;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttributes;


/** @internal
 * The JavaSoft implementation of Attributes has just one quirk.  If you
 * construct it by calling 'new Attributes(true)' (meaning case-insensitive
 * attribute ids), then when you call 'getIDs()', a list of all lower-case
 * attribute ids come back.  This is technically valid because the
 * Attributes instance is "case-insensitive".
 *
 * <p>To display attribute names correctly, we are overriding this
 * method to return mixed-case attribute ids.
 * </p>
 */
public class NAttributes
   extends BasicAttributes
   implements java.io.Serializable
{
   public NAttributes ()
   {
      super ();
   }

   public NAttributes(boolean caseIgnored)
   {
      super (caseIgnored);
   }

   public NAttributes(String attrID, Object val)
   {
      super (attrID, val);
   }

   public NAttributes(String attrID, Object val, boolean caseIgnored)
   {
      super (attrID, val, caseIgnored);
   }

   public Object clone()
   {
      NAttributes attrs = new NAttributes(isCaseIgnored());
      Enumeration enum = this.getAll();

      while (enum.hasMoreElements ())
      {
         attrs.put ((Attribute) enum.nextElement());
      }
      return (attrs);
   }

   public NamingEnumeration getIDs ()
   {
      if (isCaseIgnored ())
      {
         return (new AttrIDEnumeration (this.getAll ()));
      }
      else
      {
         return (super.getIDs());
      }
   }

} /* NAttributes */


/** @internal
 *
 */
class AttrIDEnumeration implements NamingEnumeration
{
   Enumeration enum;

   public AttrIDEnumeration (Enumeration attrEnum)
   {
      this.enum = attrEnum;
   }

   public boolean hasMoreElements ()
   {
      return (enum.hasMoreElements ());
   }

   public Object nextElement()
   {
      return (((Attribute) enum.nextElement ()).getID ());
   }

   public boolean hasMore ()
   {
      return (hasMoreElements ());
   }

   public Object next ()
   {
      return (nextElement ());
   }

   public void close ()
      throws NamingException
   {
   }

} /* AttrIDEnumeration */


