/* **************************************************************************
  $Archive: /njcl_sample/Authenticator/ModifyTokensPI.java $
  $Revision: 1 $
  $Modtime: 11/18/98 5:25p $

 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/
import com.novell.java.security.Authenticator;
import com.novell.java.security.Identity;
import com.novell.java.security.IdentityScope;
import com.novell.java.security.KeyManagementException;
import com.novell.service.security.NdsIdentity;
import com.novell.service.security.NdsPasswordIdentity;
import com.novell.service.security.NdsIdentityScope;
import com.novell.service.security.BinderyIdentity;
import com.novell.service.security.BinderyPasswordIdentity;
import com.novell.service.security.BinderyIdentityScope;
import com.novell.service.security.Password;

/**
 * Sample which demonstrates how to use <code>Authenticator.login</code>.
 */
public class ModifyTokensPI
{
   static public void main(String args[])
   {
		if(args.length < 4)
		{
			System.out.println("Usage:  ModifyTokensPI [NDS]-or-[BINDERY] domain name password newpassword");
			System.out.println("E.g.:   ModifyTokensPI [NDS] MyTree MyOrgContext MyGroupContext Me MYPASSWORD NEWPASSWORD");
			System.out.println("E.g.:   ModifyTokensPI [BINDERY] MyServer Me MYPASSWORD NEWPASSWORD");
			System.exit(-1);
		}

		try
      {
			Identity identity = null;
			if(args[0].equalsIgnoreCase(NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME))
				identity = buildNdsIdentity(null,0,args);
			else if(args[0].equalsIgnoreCase(BinderyIdentityScope.ADMINISTRATIVE_DOMAIN_NAME))
				identity = buildBinderyIdentity(null,0,args);
			else
			{
				System.out.println("You must specify either [NDS] or [BINDERY] as the first scope.");
				System.exit(-1);
			}
         Authenticator.modifyTokens(identity);
      }
      catch(java.lang.Throwable e)
      {
         if (e instanceof java.lang.ExceptionInInitializerError)
            ((java.lang.ExceptionInInitializerError)e).getException().printStackTrace();
         e.printStackTrace();
      }
		finally
		{
		   // Must exit (see bug 4072987 at
		   // http://developer.javasoft.com/developer/bugParade)
			System.exit(0);
		}
   }
   
   /*
	 * Constructs an identity with it's appropriate identity scopes.
	 * See documentation for details.
	 */
   static Identity buildNdsIdentity(IdentityScope scope, int offset, String args[])
      throws KeyManagementException
   {
      if( args.length == 0)
         return new NdsIdentity("");

      if(!(offset < args.length-3))
      {
         Identity pi = new NdsPasswordIdentity(args[offset],scope);
			((NdsPasswordIdentity)pi).setPassword(new Password(args[offset+1]));
			((NdsPasswordIdentity)pi).setNewPassword(new Password(args[offset+2]));
         return pi;
      }

      return buildNdsIdentity(new NdsIdentityScope(args[offset],scope), ++offset, args);
   }

   /*
	 * Constructs an identity with it's appropriate identity scopes.
	 * See documentation for details.
	 */
   static Identity buildBinderyIdentity(IdentityScope scope, int offset, String args[])
      throws KeyManagementException
   {
      if( args.length == 0)
         return new BinderyIdentity("");

      if(!(offset < args.length-3))
      {
         Identity pi = new BinderyPasswordIdentity(args[offset],scope);
			((BinderyPasswordIdentity)pi).setPassword(new Password(args[offset+1]));
			((BinderyPasswordIdentity)pi).setNewPassword(new Password(args[offset+2]));
         return pi;
      }

      return buildBinderyIdentity(new BinderyIdentityScope(args[offset],scope), ++offset, args);
   }
}