/***************************************************************************
 %name: FileAttrList.java
 %version: 
 %date_modified: 
 %dependencies: DynamicAttributeValueInterface.java \
    StaticAttributeValueInterface.java TextualDynamic.java \
    TextualStatic.java
 
 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;

import javax.naming.directory.DirContext;

import com.novell.service.file.nw.NetwareFile;
import com.novell.service.file.nw.DirectoryEntryInformation;
import com.novell.service.file.nw.TrusteeEnumerator;
import com.novell.service.file.nw.EAEnumerator;

import com.novell.utility.naming.Environment;

/**
 * Displays the attributes for a file in the NetWare file system.
 *
 * <p>This program demonstrates using the Dynamic and Static attribute
 * interfaces of a file DirContext in the NetWare file system.
 *
 * <p>The attribute values shown in the see list below are associated with a
 * directory and their use is outlined here:
 *
 * @see com.novell.service.file.nw.DirectoryEntryInformation
 * @see com.novell.service.file.nw.TrusteeEnumerator
 * @see com.novell.service.file.nw.EAEnumerator
 * </p>
 */

public class FileAttrList
{
   /**
    * FileAttrList example
    *
    * <p>This example lists the Attributes associated with a File
    * DirContext in the NetWare file system name space.
    * </p>
    *
    * @param   args[]
    * where    args[0]  url (url to list)
    *                   The name of a File DirContext from the
    *                   File System initial context.  For example:
    *                   "my_server/my_volume/my_dir/my_file"
    */

   public static void main(String args[])
   {
      // see if user has given the URL on the command line
      if (args.length < 1)
      {
         help();
      }

      String url = args[0];
      StaticAttributeValueInterface sai = new TextualStatic(true);
      DynamicAttributeValueInterface dai = new TextualDynamic(true);

      // Set the initial context factory to NetWareInitialContextFactory
      Hashtable systemProps = new Hashtable();
      systemProps.put(
         Context.INITIAL_CONTEXT_FACTORY,
         Environment.FS_INITIAL_CONTEXT_FACTORY);

      systemProps.put(Context.PROVIDER_URL, url);

      try
      {
         // Look up the object named by the command line parameter.
         Object obj = new InitialContext(systemProps).lookup("");

         System.out.println("\nGetting attributes for file: " + url + "\n");

         /*
            First show the static interface to the attributes
         */

         System.out.println(
            "\nStatic method, using the NetwareFile interface\n");

         if (!(obj instanceof NetwareFile))
         {
            System.out.println(url + " does not specify a file");
            System.exit(-1);
         }

         // obtain and handle the Directory Entry Information
         sai.handleDirectoryEntryInformation((NetwareFile)obj);

         // obtain and handle the Trustees
         sai.handleTrusteeEnumerator((NetwareFile)obj);

         // obtain and handle the Extended Attributes
         sai.handleEAEnumerator((NetwareFile)obj);


         /*
            Now show the dynamic interface to the attributes
         */

         System.out.println(
            "\nDynamic method, using the JNDI Attributes interface\n");

         // obtain and handle the Directory Entry Information
         dai.handleDirectoryEntryInformation(
            (DirectoryEntryInformation)
            dai.getAttribute(
               DirectoryEntryInformation.ATTRIBUTE_ID,
               (DirContext)obj),
            (DirContext)obj);

         // obtain and handle the Trustees
         dai.handleTrusteeEnumerator(
            (NamingEnumeration)
            dai.getAttribute(
               TrusteeEnumerator.ATTRIBUTE_ID,
               (DirContext)obj),
            (DirContext)obj);

         // obtain and handle the Extended Attributes
         dai.handleEAEnumerator(
            (NamingEnumeration)
            dai.getAttribute(
                EAEnumerator.ATTRIBUTE_ID,
                (DirContext)obj),
            (DirContext)obj);

      }
      catch (javax.naming.NamingException e)
      {
         System.out.println("Exception thrown: " + e);
         e.printStackTrace();
         System.exit(-1);
      }
      System.exit(0);
   }

   private static void help()
   {
      System.out.println(
         "\nTo use this example program enter the following:\n");
      System.out.println(
         "\tjava FileAttrList <url>\n");
      System.out.println(
         "\t\turl = name of the File to list attributes on");
      System.out.println("\t\t       my_server/my_volume/my_dir/my_file");
      System.out.println("");
      System.exit(-1);
   }
}

