/* **************************************************************************
 %name: %
 %version: %
 %date_modified: %

 Copyright (c) 1997,1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import javax.naming.*;

/**
 * Contains a Context and the name that can be used to look up that
 * context from an initial context.
 */
public class NamedContext
{
   Name name;
   Context ctx;
   Context initCtx;

  /**
   * Constructs a NamedContext object based on the name, context
   * and initial context.
   *
   * @param name The name to use to look up the context.
   * @param ctx  The Context that can be looked up by the name.
   * @initCtx    The inital context.
   */
   public NamedContext (Name name, Context ctx, Context initCtx)
   {
      this.name = name;
      this.ctx = ctx;
      this.initCtx = initCtx;
   }

  /**
   * Returns the name to look up.
   *
   * @return The name to look up as a Name object.
   */
   public Name getName ()
   {
      return (name);
   }

  /**
   * Returns the context looked up by the name.
   *
   * @return The context looked up by the name.
   */
   public Context getContext ()
   {
      return (ctx);
   }

  /**
   * Returns the initial context as a Context object.
   *
   * @return The initial context.
   */
   public Context getInitialContext ()
   {
      return (initCtx);
   }
}
