/****************************************************************************
  $Archive: /njcl_sample/NJCLApplet/src/AboutFrame.java $
  $Revision: 1 $
  $Modtime: 3/18/99 4:15p $

  Copyright (c) 1999 Novell, Inc.  All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
 ***************************************************************************/

import java.awt.*;
import java.awt.event.*;
import java.net.URL;

import javax.swing.*;

/**
 * This class provides an About dialog (frame) which lists the apps features.
 */

public class AboutFrame
   extends JFrame
   implements ActionListener
{
   private static int buttonHeight = 25;
   private static int buttonWidth = 100;
   private static int mainPaneHeight = 200;
   private static int mainPaneWidth = 400;

   private JButton      okButton;
   private JScrollPane  scrollPane;
   private JTextArea    textArea;
   private JEditorPane  textPane;

   private static AboutFrame singleton;

   String[] helpStr = new String[] 
   {
      "        NJCLApplet version Brainshare US 1999",
      "Copyright (c) 1999 Novell, Inc.  All Rights Reserved.",
      "",
      "-----------------------------------------------------",
      "",
      "               !!!MISSING ABOUT.HTML!!!"
   };

   /**
    * Return the singleton about frame.
    *
    * <p>Because this about frame provides a lot of useful information, it is
    * likely to be left up and used as a guide through the sample.
    * Consequently, rather than create, destroy and re-create this dialog all
    * the time, we'll create it once and hang on to it and show and hide it
    * instead.
    *
    * @param codeBase            Specified where to find the about.html file.
    *                            This parameter is only needed on the first
    *                            call.
    */
   static public AboutFrame getAboutFrame (
         URL codeBase)
   {
      if (null == singleton)
         singleton = new AboutFrame (codeBase);
      return (singleton);
   } // getAboutFrame ()

   /**
    * Constructs the AboutFrame with all controls, etc..
    */
   private AboutFrame (
         URL codeBase)
   {
      super ("About NJCL Applet");
      getContentPane ().setLayout (new BorderLayout ());
      setSize (mainPaneWidth, mainPaneHeight);

      // The viewer window
      scrollPane = new JScrollPane ();
      try
      {
         textPane = new JEditorPane ();
         textPane.setEditable (false);
         URL url = new URL (codeBase, "about.html");
         textPane.setPage (url);
         scrollPane.getViewport ().add (textPane);
      }
      catch (Exception e)
      {
         (new MessageBox (
                  "Error",
                  "Unable to find about.html (using default):\n" +
                  Util.getExceptionTrace (e))).show ();
         textArea = new JTextArea ();
         textArea.setEditable (false);
         textArea.setFont (new Font ("Courier", Font.PLAIN, 12));
         String newLine = System.getProperty ("line.separator");
         for (int i = 0; i < helpStr.length; i++)
            textArea.append (helpStr[i] + newLine);
         scrollPane.getViewport ().add (textArea);
      }
      getContentPane ().add (scrollPane, "Center");
      
      // Buttons
      JPanel buttonPanel = new JPanel (new FlowLayout (FlowLayout.CENTER));
      okButton = new JButton ("OK");
      okButton.setToolTipText ("Close this window");
      okButton.setSize (buttonWidth, buttonHeight);
      okButton.addActionListener (this);
      buttonPanel.add (okButton);
      getContentPane ().add (buttonPanel, "South");

      setDefaultCloseOperation (HIDE_ON_CLOSE);
   } // AboutFrame ()
   
   // ActionListener interface methods ---------------------------------------
   /**
    * ActionListener event handler method.
    *
    * @param event               The event describing what action occured.
    */
   public void actionPerformed (
         ActionEvent event)
   {
      Object object = event.getSource ();
      
      if (object == okButton)
         setVisible (false);
   } // actionPerformed ()
} // AboutFrame ()