/****************************************************************************
  $Archive: /njcl_sample/NJCLApplet/src/PopupHandler.java $
  $Revision: 2 $
  $Modtime: 3/11/99 3:29p $

  Copyright (c) 1999 Novell, Inc.  All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
 ***************************************************************************/

import javax.swing.JPopupMenu;
import javax.swing.JFrame;

/**
 * This interface defines a 'snap-in' that keys off of a popup menu.
 * Custom object handlers can be defined that provide additional
 * functionality for an object based on its class, or any of the interfaces
 * it implements. This allows for endless extensibility to the common
 * browser interface provided in this demo.
 */
public interface PopupHandler
{
   /**
    * Method called for registered handlers when the popup event occurs.
    *
    * @param frame               The frame in which the popup is being
    *                            requested.
    * @param popup               The popup menu being created. If the handler
    *                            wants to provide custom handling for the
    *                            object being passed, it can add one or more
    *                            to this menu before returnning. Otherwise
    *                            it can ignore this request.
    * @param obj                 The object being customized. This is likely
    *                            to be a ContextTreeNode.
    */
   public void popupRequested (
      JFrame frame,
      JPopupMenu popup,
      Object obj);
} // interface PopupHandler
