/****************************************************************************
  $Workfile: SortableString.java $
  $Revision: 1 $
  $Modtime:: $
  $Copyright:

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.$

 ***************************************************************************/

class SortableString extends Sortable
{
   String keyStr;
   String extraStr;

   public SortableString()
   {
      keyStr = new String();
   }

   public SortableString (
         String value)
   {
      keyStr = new String (value);
   }

   public SortableString (
         String key,
         String extra)
   {
      keyStr = key;
      extraStr = extra;
   }

   public String getKeyStr ()
   {
      return keyStr;
   }

   public int compare (
         Object other)
   {
      return compare ((SortableString) other);
   }

   public int compare (
         SortableString other)
   {
      int i = keyStr.compareTo (other.getKeyStr());
      if (i < 0) return -1;
      if (i > 0) return 1;
      return 0;
   }

   public String toString ()
   {
      if (null == extraStr)
         return (keyStr);
      else
         return (keyStr + ":" + extraStr);
   }

} // class SortableString

