/***************************************************************************
%name: 
%version: 
%date_modified: 
%dependencies: none

Copyright (c) 1998 Novell, Inc. All Rights Reserved.

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/
import java.util.*;
import javax.naming.*;
import javax.naming.directory.*;
import com.novell.utility.naming.Environment;
import com.novell.service.qms.QMSQueue;
import com.novell.service.qms.naming.QMSEnvironment;
import com.novell.service.bindery.*;

/** 
* Uses JNDI to create/delete a queue
*/
public class QueueCreateDelete
{
   public static void createQueue(String serverName, String queueName, Integer queueType)
   throws Exception
   {
      Hashtable hash = new Hashtable();
      hash.put(Context.INITIAL_CONTEXT_FACTORY, Environment.NW_INITIAL_CONTEXT_FACTORY);
      hash.put(Context.PROVIDER_URL, "NetWare:///Servers/" + serverName);
         
      DirContext dirCtx = new InitialDirContext (hash);
      dirCtx = (DirContext)dirCtx.lookup("Bindery");
      
      DirContext adminCtx = (DirContext)dirCtx.lookup("admin+1");
      Attribute adminID = adminCtx.getAttributes("").get("Bindery ID");
      Integer id = (Integer)adminID.get();

      Attributes attrs = new BasicAttributes();
      attrs.put("Bindery Type", queueType);
      attrs.put("Security", new Integer(BinderyUtil.BS_SUPER_WRITE | BinderyUtil.BS_ANY_READ));
      attrs.put("Dynamic", new Boolean(false));
      
      Attribute attr = new BasicAttribute("Bindery Properties");
      BinderyPropertyAttrVal val;
      val = new BinderyPropertyAttrVal("Q_DIRECTORY",
         BinderyUtil.BF_STATIC | BinderyUtil.BF_ITEM,
         BinderyUtil.BS_SUPER_READ | BinderyUtil.BS_SUPER_WRITE);
      val.addDataSegment(new BinderyPropertyDataSegment(
         (new String("SYS:SYSTEM\\QDIR").getBytes()), 1, BinderyUtil.BF_ITEM));
      attr.add(val);
      
      val = new BinderyPropertyAttrVal("Q_OPERATORS",
         BinderyUtil.BF_STATIC | BinderyUtil.BF_SET,
         BinderyUtil.BS_SUPER_READ | BinderyUtil.BS_SUPER_WRITE);
      Vector operatorIds = new Vector();
      operatorIds.addElement(id);
      val.addDataSegment(new BinderyPropertyDataSegment(
         operatorIds, 1, BinderyUtil.BF_SET));
      attr.add(val);

      val = new BinderyPropertyAttrVal("Q_USERS",
         BinderyUtil.BF_STATIC | BinderyUtil.BF_SET,
         BinderyUtil.BS_SUPER_READ | BinderyUtil.BS_SUPER_WRITE);
      Vector userIds = new Vector();
      userIds.addElement(id);
      val.addDataSegment(new BinderyPropertyDataSegment(
         userIds, 1, BinderyUtil.BF_SET));
      attr.add(val);
      attrs.put(attr);

      dirCtx.createSubcontext(queueName, attrs);
   }

   public static void deleteQueue(String serverName, String queueName, Integer queueType)
   throws Exception
   {
      Hashtable hash = new Hashtable();
      hash.put(Context.INITIAL_CONTEXT_FACTORY, Environment.NW_INITIAL_CONTEXT_FACTORY);
      hash.put(Context.PROVIDER_URL, "NetWare:///Servers/" + serverName);
         
      DirContext dirCtx = new InitialDirContext (hash);
      dirCtx = (DirContext)dirCtx.lookup("Bindery");
      dirCtx.destroySubcontext(queueName + "+" + queueType.intValue());
   }

   /**
   * @param   args[]
   * where    args[0]  serverName
   *          args[1]  queueName
   *          args[2]  queueType
   */
   public static void main(String args[])
   {
      String serverName = args[0];
      String queueName  = args[1];
      String queueType  = args[2];

      try
      {
         createQueue(serverName, queueName, new Integer(queueType));
         deleteQueue(serverName, queueName, new Integer(queueType));
      }
      catch(Exception e)
      {
         e.printStackTrace();
      } 
   }      
}
