/* **************************************************************************

  $Archive: /njcl/src/com/novell/java/security/AuthenticatorException.java $
  $Revision: 12 $
  $Modtime: 4/02/99 3:56p $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.java.security;

/**
 * Employs a "root-cause" mechanism by which the original exception,
 * which may be provider-specific, can be recovered. This exception
 * is the root of the authentication exception hierarchy.
 *
 * @author Jan Sture Nielsen
 * @version 1.0.0
 */
public class AuthenticatorException
	extends		java.lang.RuntimeException
	implements	java.io.Serializable,
					com.novell.java.lang.HasRootCause
{
	/**
	 * The root-cause exception.
	 */
	protected java.lang.Throwable rootException = null;

   /**
    * The default constructor.
    */
   public AuthenticatorException()
   {
      super(I2L.getString(XMsg.AUTHENTICATOR));
   }

   /**
    * Constructor with a String message.
    *
    * @param message A message associated with the exception.
    */
   public AuthenticatorException(String message)
   {
      super(message);
   }

   /**
    * Constructor with a string message and a root cause exception.
    *
    * @param message A message associated with the exception.
    * @param exception The root cause exception.
    */
   public AuthenticatorException(String message,java.lang.Throwable exception)
   {
      super(message);
      this.rootException = exception;
   }

   /**
	 * Returns the root-cause exception.
    *
    * @return The root-cause exeption.
	 */
	public java.lang.Throwable getRootCause()
	{
		return rootException;
	}

	/**
	 * An override the to show both exceptions.
	 */
	public void printStackTrace()
	{
		super.printStackTrace();
		if(rootException != null)
			rootException.printStackTrace();
	}

	/**
	 * Returns a String representation of the exception object.
    *
    * @return A string representation of the exception.
	 */
   public String toString()
   {
      if (rootException == null)
         return super.toString();
      else
         return "[Root exception is " + rootException.toString() + "]" +
               super.toString();
   }


}
