/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/bindery/BinderyObjectClassDefContext.java $
  $Revision: 7 $
  $Modtime: 10/18/99 11:50a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.bindery;


import javax.naming.*;

import com.novell.utility.naming.directory.StaticClassDefContext;


/**@internal
 * Schema class def root for the bindery system.
 *
 * <p>This is the root schema DirContext that is returned from all bindery
 * contexts getSchemaClassDefinitions methods.
 * </p>
 */

public class BinderyObjectClassDefContext extends StaticClassDefContext
{
   /* ***********************************************************************
    * These arrays are parallel and are used to construct the
    * childNameClassPairs and childBindings. Each array must contain an
    * entry for each child and each array must be the same length.
    * Consequently, if you add or delete a subordinate, you must add a 
    * subordinate in each of the following three arrays:
    *   childNames = The string (name) used by lookup
    *   childClasses = The class name placed in the NameClassPair
    *   childObjects = The object placed in the Binding
    ************************************************************************/

   protected static String binderyChildNames[] = {};

   protected static String binderyChildClasses[] = {};

   protected static Object binderyChildObjects[] = {};

   /* ***********************************************************************
    * These arrays are also related. For each entry in the attrNames array
    * there is a corresponding array entry in the attrValues array. Note
    * that because a single attribute can have multiple values, the elements
    * of the attrValues array must be arrays of objects, rather than just
    * simple objects. Single value attributes will have an array of one
    * object in the attrValues array entry for that attribute.
    *
    * Although this example shows only String values in the attrValues array,
    * the attribute values may be any Object (or subclass of Object).
    *
    * attrNames = The array of attribute Ids (names)
    * attrValues = The array of values for the attributes
    */

   protected static String attrNames[] = 
   {
      "Bindery Type",      // so can create an object without a mangled name
      "Bindery ID",
      "Security",
      "Dynamic",
      "Has Properties",
      "Bindery Properties"
   };

   protected static Object attrValues[][] =
   {
      {"java.lang.Integer"},                          // Type
      {"java.lang.Integer"},                          // ID
      {"java.lang.Integer"},                          // Security
      {"java.lang.Boolean"},                          // Dynamic
      {"java.lang.Boolean"},                          // Has Properties
      { ClassNames.BINDERY_PROPERTY }
   };

   /**  These static ints can be used to access the specific attrNames.
    *   They exist so that the names can change.
    */

   public final static int TYPE_NAME           = 0;
   public final static int ID_NAME             = 1;
   public final static int SECURITY_NAME       = 2;
   public final static int DYNAMIC_NAME        = 3;
   public final static int HAS_PROPERTIES_NAME = 4;
   public final static int PROPERTIES_NAME     = 5;
   public final static int NUMBER_OF_NAMES     = 6;

   /**
    *  This constructor sets the static schema class and object arrays,
    *  as well as the attribute array.
    */
    
   public BinderyObjectClassDefContext ()
   {
      super ("Classes/Bindery Object");

      initBindingsAndPairs (
                              binderyChildNames,
                              binderyChildClasses,
                              binderyChildObjects);

      initAttributes (attrNames, attrValues);

   } // BinderyObjectClassDefContext ()

} /* class BinderyObjectClassDefContext */


