/****************************************************************************
  $Workfile: JNIString.h $
  $Revision: 2 $
  $Modtime:: 12/03/96 12:35p                               $
  $Copyright:

  Copyright (c) 1989-1995 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.$

 ***************************************************************************/

#if ! defined( JNISTRING_H )
#define JNISTRING_H

/*
 * Java string utilities
 */

#include <jni.h>
#include <nunicode.h>

#define JAVAPKG "java/lang/"

N_EXTERN_FUNC(NWRCODE) __InitNativeUnicode(void);
N_EXTERN_FUNC(void) __CleanupNativeUnicode(void);

unicode *jstring2unicode
(
   JNIEnv *env,
   jstring string,
   unicode *buf,
   int bufLen
);

void __ThrowException
(
   JNIEnv *env,
   char *fullClassName,
   char *msg
);

NWRCODE __UnicodeToLocalStr
(
   pnstr8 destStr,
   nuint destStrSize,
   punicode uniStr,
   jint javaLength
);

NWRCODE __UnicodePathToLocalStr
(
   pnstr8 destStr,
   nuint destStrSize,
   punicode uniStr,
   jint javaLength
);

NWRCODE __LocalToJavaStr
(
   JNIEnv *env,
   jstring *pJavaStr,
   punicode uniBuffer,
   pnstr8 srcStr
);

// for the unicode function tables below
typedef NWRCODE (*utol_t)(pnstr8, nuint, punicode, jint);
typedef NWRCODE (*ltoj_t)(JNIEnv *, jstring *, punicode, pnstr8);

// for a dynamic load version of calls to the new unicode APIs
//   because we can't call them through the headers because we can't
//   break loading JNCP.NLM on pre-ServicePack6 GreenRiver servers
typedef nint (*NWUSGetCodePage_t)(pnuint, pnuint);
typedef nint (*NWUXLoadByteUnicodeConverter_t)(nuint, pCONVERT*);
typedef void (*NWUXUnloadConverter_t)(pCONVERT*);
typedef nint (*NWUXByteToUnicode_t)(pCONVERT*, punicode, nuint, pnuint8, pnuint);
typedef nint (*NWUXUnicodeToByte_t)(pCONVERT*, pnuint8, nuint, punicode, pnuint);
typedef nint (*NWUXUnicodeToBytePath_t)(pCONVERT*, pnuint8, nuint, punicode, pnuint);

//
// unicodeFunctions points to an array of __UnicodeToLocalStr,
//   __UnicodePathToLocalStr, and __LocalToJavaStr functions
//
// depending on which conversion tables are present at startup, this
//   will point to the appropriate array of function pointers
//
// item 0 points to implementation of __UnicodeToLocalStr      (utol_t)
// item 1 points to implementation of __UnicodePathToLocalStr  (utol_t)
// item 2 points to implementation of __JavaToLocalStr         (ltoj_t)
//
N_EXTERN_VAR void **_unicodeFunctions;
N_EXTERN_VAR void *standardUniFunctions[];
N_EXTERN_VAR void *oldUniFunctions[];

//
// these must be valid if 'unicodeFunctions' points to 'oldUniFunctions'
//
N_EXTERN_VAR nptr _hUnicodeToLocal;
N_EXTERN_VAR nptr _hLocalToUnicode;

//
// this must be valid if 'unicodeFunctions' points to 'standardUniFunctions'
//
N_EXTERN_VAR pCONVERT _unicodeConverter;

//
// 1 if unicode has been initialized, 0 means not initialized (default)
//
N_EXTERN_VAR int _unicodeInitialized;

//
// 1 if using standard APIs (default), 0 if using old APIs
//
N_EXTERN_VAR int _usingStandardUnicode;

#ifdef N_PLAT_NLM

//
// the standard unicode functions have to be loaded dynamically on
//   the NLM platform so that we don't require Service Pack 6 on Green River
//   servers.  This is the jump table for this dynamic loading.
//
typedef struct StandardUnicodeJumpTable_tag
{
   NWUSGetCodePage_t getCP;
   NWUXLoadByteUnicodeConverter_t loadConverter;
   NWUXUnloadConverter_t unloadConverter;
   NWUXByteToUnicode_t byteToUnicode;
   NWUXUnicodeToByte_t unicodeToByte;
   NWUXUnicodeToBytePath_t unicodeToBytePath;
} StandardUnicodeJumpTable, N_FAR *pStandardUnicodeJumpTable;

N_EXTERN_VAR pStandardUnicodeJumpTable _NLMUnicodeJumpTable;

#endif

#endif /* !JNISTRING_H */
