/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include <unicode.h>

#include "jncpWire.h"

#include "NetClassNameJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetClassName
 *    extends NdsClassName
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetClassName)
NetClassNameCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetClassName;
   jclass clsNetClassNameLR;
   //NJCL variables
   pNetClassName sNetClassName;

   clsNetClassNameLR = (*env)->FindClass (env, NETSYNTAXPKG "NetClassName");
   clsNetClassName = (*env)->NewGlobalRef (env, clsNetClassNameLR);
   (*env)->DeleteLocalRef (env, clsNetClassNameLR);

   sNetClassName = (pNetClassName) sysMalloc (sizeof (NetClassName));

   if (NULL != sNetClassName)
   {
      // assign jclass variables
      sNetClassName->cls = clsNetClassName;

      // assign jfieldID variables
      sNetClassName->ID.value = (*env)->GetFieldID (env, clsNetClassName, "value", "Ljava/lang/String;");
   }
   return (sNetClassName);

} /* NetClassNameCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetClassNameCreate
(
   JNIEnv *env,
   pNetClassName sNetClassName,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netClassName = (*env)->AllocObject (env, sNetClassName->cls);

   {
      jstring value;

      NAlign32 (curPos);
      (*env)->SetObjectField (
                                 env,
                                 netClassName,
                                 sNetClassName->ID.value,
                        (jobject)(value = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, value);
   }

   return (netClassName);

} /* NetClassNameCreate () */


