/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include <unicode.h>

#include "jncpWire.h"

#include "NetFAXNumberJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetFAXNumber
 *    extends NdsFAXNumber
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetFAXNumber)
NetFAXNumberCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetFAXNumber;
   jclass clsNetFAXNumberLR;
   //NJCL variables
   pNetFAXNumber sNetFAXNumber;

   clsNetFAXNumberLR = (*env)->FindClass (env, NETSYNTAXPKG "NetFAXNumber");
   clsNetFAXNumber = (*env)->NewGlobalRef (env, clsNetFAXNumberLR);
   (*env)->DeleteLocalRef (env, clsNetFAXNumberLR);

   sNetFAXNumber = (pNetFAXNumber) sysMalloc (sizeof (NetFAXNumber));

   if (NULL != sNetFAXNumber)
   {
      // assign jclass variables
      sNetFAXNumber->cls = clsNetFAXNumber;

      // assign jfieldID variables
      sNetFAXNumber->ID.telephoneNumber = (*env)->GetFieldID (env, clsNetFAXNumber, "telephoneNumber", "Ljava/lang/String;");
      sNetFAXNumber->ID.bitCount = (*env)->GetFieldID (env, clsNetFAXNumber, "bitCount", "I");
      sNetFAXNumber->ID.parameters = (*env)->GetFieldID (env, clsNetFAXNumber, "parameters", "[B");
   }
   return (sNetFAXNumber);

} /* NetFAXNumberCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetFAXNumberCreate
(
   JNIEnv *env,
   pNetFAXNumber sNetFAXNumber,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netFAXNumber = (*env)->AllocObject (env, sNetFAXNumber->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      jstring telephoneNumber;

      (*env)->SetObjectField (
                                 env,
                                 netFAXNumber,
                                 sNetFAXNumber->ID.telephoneNumber,
                        (jobject)(telephoneNumber = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, telephoneNumber);
   }

   {
      NAlign32 (curPos);
      (*env)->SetIntField (
                              env,
                              netFAXNumber,
                              sNetFAXNumber->ID.bitCount,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   {
      jbyteArray parameters;
      pnstr8 cParameters;
      nuint32 length;

      cParameters = jncpGetData (env, curPos, limit, &length);
      parameters = (*env)->NewByteArray (env, length); 
      (*env)->SetByteArrayRegion (env, parameters, 0, length, (jbyte *) cParameters); 
      (*env)->SetObjectField (
                                 env,
                                 netFAXNumber,
                                 sNetFAXNumber->ID.parameters,
                       (jobject) parameters);
      (*env)->DeleteLocalRef (env, parameters);
   }

   return (netFAXNumber);

} /* NetFAXNumberCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/*
 * typedef struct
 * {
 *    pnstr8         telephoneNumber ;
 *    Bit_String_T   parameters ;
 * } Fax_Number_T;
 *
 *    typedef struct
 *    {
 *       nuint32   numOfBits ;
 *       nptr      data ;
 *    } Bit_String_T;
 * 
 * CStruct
 *  | teleNumberptr | numOfBits | dataptr | teleNumber | data |
 *
 * java array:
 *  | teleNumber | numOfBits | data |
 */

N_GLOBAL_FUNC_C (jbyteArray)
NetFAXNumber_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
   jbyteArray byteArray;
   // NWNet variables
   pFax_Number_T faxNumber;
   nuint8 *faxNumberPtr, *ptr;
   nuint32 numOfBits;

   // NdsMemory.handle - ReplicaPointer C struct
   faxNumber = (pFax_Number_T) cValue;

   // malloc temporary buffer
   faxNumberPtr = (nuint8 *) sysMalloc (cLength);
   ptr = faxNumberPtr;

   // build the temporary buffer
   unicpy ((unicode *) ptr, (unicode *) faxNumber->telephoneNumber);
   ptr += (unilen ((unicode *) ptr) + 1) * sizeof (unicode);
             
   *(pnuint32) ptr = numOfBits = faxNumber->parameters.numOfBits;
   ptr += sizeof (nuint32);

   memcpy (ptr, faxNumber->parameters.data, (size_t)((numOfBits + 7) / 8));

   // allocate return byte[]
   byteArray = (*env)->NewByteArray (env, cLength);

   // copy temporary buffer to byte[]
   (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) faxNumberPtr);

   // free temporary buffer
   sysFree (faxNumberPtr);

   return (byteArray);

} /* fromCStruct () */
   

/*
 *
 */
N_GLOBAL_FUNC_C (nptr) 
NetFAXNumber_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   pFax_Number_T faxNumber;
   nuint8 *dataPtr;

   // get byte[]
   byteArray = (*env)->GetByteArrayElements (env, values, 0);
   ptr = byteArray;

   // calculate NetMemory size
   length = (*env)->GetArrayLength (env, values) + sizeof(Fax_Number_T);

   // malloc NetMemory buffer
   faxNumber = (pFax_Number_T) sysMalloc (length);
   dataPtr = (pnchar)(faxNumber) + sizeof(Fax_Number_T);

   // build the buffer
   faxNumber->telephoneNumber = (pnchar) dataPtr;
   unicpy ((unicode *) faxNumber->telephoneNumber, (unicode *) ptr);
   length = (unilen ((unicode *) ptr) + 1) * sizeof (unicode);
   ptr += length;
   dataPtr += length;

   if (0 == (faxNumber->parameters.numOfBits = *(nuint32 *) ptr))
   {
      faxNumber->parameters.data = NULL;
   }
   else
   {
      ptr += sizeof(nuint32);

      faxNumber->parameters.data = (pnchar) dataPtr;
      memcpy (
                  faxNumber->parameters.data, 
                  ptr, 
         (size_t)(faxNumber->parameters.numOfBits + 7) / 8);
   }

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) faxNumber);

} /* toCStruct () */


#ifdef __cplusplus
}
#endif


