/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include "jncpWire.h"

#include "NetIntervalJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetInterval
 *    extends NdsInterval
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected boolean value;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetInterval)
NetIntervalCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetInterval;
   jclass clsNetIntervalLR;
   //NJCL variables
   pNetInterval sNetInterval;

   clsNetIntervalLR = (*env)->FindClass (env, NETSYNTAXPKG "NetInterval");
   clsNetInterval = (*env)->NewGlobalRef (env, clsNetIntervalLR);
   (*env)->DeleteLocalRef (env, clsNetIntervalLR);

   sNetInterval = (pNetInterval) sysMalloc (sizeof (NetInterval));

   if (NULL != sNetInterval)
   {
      // assign jclass variables
      sNetInterval->cls = clsNetInterval;

      // assign jfieldID variables
      sNetInterval->ID.value = (*env)->GetFieldID (env, clsNetInterval, "value", "I");
   }
   return (sNetInterval);

} /* NetIntervalCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetIntervalCreate
(
   JNIEnv *env,
   pNetInterval sNetInterval,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netInterval = (*env)->AllocObject (env, sNetInterval->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      (*env)->SetIntField (
                              env,
                              netInterval,
                              sNetInterval->ID.value,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   return (netInterval);

} /* NetIntervalCreate () */


