
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/jncpv2/net/AliasNetService.java $
  $Revision: 9 $
  $Modtime: 1/28/00 11:48a $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.jncpv2.net;


import com.novell.service.session.xplat.NDSContextInfo;

import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.service.jncpv2.clx.ClxJNI;

import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.NDSContext;


/** @internal
 * Object returned by Session.getService() that wraps all NWNET
 * native services (via NetJNI).
 */
public final class AliasNetService
   extends BasicNetService
{
   /**
    * The key used to generate an object of this type via the
    * Session.getService() interface.
    */
// Please leave OLD versions here but commented out for the purpose of
// tracking unique identifiers.
//   public static final String KEY =
//"com.novell.service.jncpv2.net.NetService.1049854532";
   public static final String KEY =
"com.novell.service.jncpv2.net.AliasNetService.1049854532";

   /**
    *
    */
   public AliasNetService (
         NDSContext context)
      throws SessionException
   {
      super (context);

      int ccode;
      Integer flags;
      NDSContextInfo info = new NDSContextInfo ();

      // get DCK_FLAGS
      ccode = ClxJNI.NWDSGetContext (threadGroup, hdlContext,
            ClxJNI.DCK_FLAGS, info);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      // turn DCV_DEREF_ALIASES off
      flags = (Integer) info.getValue ();
      flags = new Integer (flags.intValue () & ~ClxJNI.DCV_DEREF_ALIASES);

      // set DCK_FLAGS
      ccode = ClxJNI.NWDSSetContext (threadGroup, hdlContext,
            ClxJNI.DCK_FLAGS, flags);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* AliasNetService () */

} /* AliasNetService */

