
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/jncpv2/net/NetEntryInfoEnumerator.java $
  $Revision: 8 $
  $Modtime: 1/28/00 12:45p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.jncpv2.net;


import java.util.Enumeration;
import java.util.NoSuchElementException;

import com.novell.service.jncp.NSIException;

import com.novell.service.session.SessionException;


/** @internal
 *
 */
public final class NetEntryInfoEnumerator implements Enumeration
{
   private NetEntryInfo[] entries;
   private int count;


   /**
    *
    */
   public NetEntryInfoEnumerator (
         NetService service,
         String objectName,
         int bufferSize)
      throws NSIException
   {
      try
      {
         count = 0;
         entries = service.listEntries (
                                             objectName,
                                             bufferSize);
      }
      catch (SessionException e)
      {
         throw (new NSIException ());
      }

   }

   /**
    *
    */
   public boolean hasMoreElements ()
   {
      return (count < entries.length);
   }

   /**
    *
    */
   public Object nextElement ()
   {
      try
      {
         return (entries[count++]);
      }
      catch (ArrayIndexOutOfBoundsException e)
      {
         throw (new NoSuchElementException ());
      }
   }

} /* NetEntryInfoEnumerator */


