
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/NdsReplica.java $
  $Revision: 12 $
  $Modtime: 1/28/00 12:45p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


import com.novell.service.nds.naming.NdsPartitionOperationException;

import com.novell.service.jncp.NSIException;


/**
* Defines variables and methods for replica operations.
*
*/

public interface NdsReplica
{
   /**
    * Master replica created when the partition is defined
    * and used to perform partition operations.
    *
    * <p>(REPLICATYPE_MASTER = 0)
    */
   public final static int REPLICATYPE_MASTER = 0;

   /**
    * Secondary or read/write replica, which is created for a
    * specific partition receiving client updates.
    *
    * <p>(REPLICATYPE_SECONDARY = 1)
    */
   public final static int REPLICATYPE_SECONDARY = 1;

   /**
    * Read-only replica, which will not receive client updates
    * and can only be updated from master or read-write replicas.
    *
    * <p>(REPLICATYPE_READONLY = 2)
    */
   public final static int REPLICATYPE_READONLY = 2;

    /**
    * Synchronization flag that sets the Action Flag to the On
    * state causing the action to be performed immediately.
    *
    * <p>If the Action Flag is not set to ON the synchronization
    * is queued to be performed after a delay of a specified
    * number of seconds.
    * 
    * <p>(SF_DO_IMMEDIATE = 1)
    */
   public final static int SF_DO_IMMEDIATE = 1;

    /**
    * Synchronization flag that sets the Transition Action Flag
    * to the ON state.
    *
    * <p>If the replica is in a New, Dying, or Transition
    * On state, the request is ignored and SUCCESS is returned.
    *
    * <p>(SF_TRANSITION = 2)
    */
   public final static int SF_TRANSITION = 2;

    /**
    * Synchronization flag for sending all replica updates
    * at the time of the next scheduled synchronization.
    * 
    * <p>(SF_SEND_ALL = 4)
    */
   public final static int SF_SEND_ALL = 4;

   /**
    * Sets the replica type for the partition.
    *
    * @param type Replica type defined as: REPLICATYPE_MASTER,
    *             REPLICATYPE_SECONDARY, or REPLICATYPE_READONLY.
    *
    * @exception PartitionOperationException
    */
   public void setReplicaType (
         int type)
      throws NdsPartitionOperationException;

   /**
    * Synchronizes replicas to the specified server, restricted by
    * the specified flags and time delay.
    *
    * <p>This syncReplica() method updates each replica of a partition
    * after an addition, deletion, or modification to NDS by providing 
    * a wrapper for the NWDSSyncReplicaToServer function.
    *
    * @param destServer Server with which to synchronize the replica.
    * @param flags      Synchronization flags (SF_DO_IMMEDIATE, SF_
    *                   TRANSITION, SF_SEND_ALL).
    * @param delay      Time delay after which to start the
    *                   synchronization process.
    *
    * @exception PartitionOperationException Naming Exception indicating
    *                                        that the operation failed.
    */
   public void syncReplica(
         String destServer,
         int flags,
         int delay)
      throws NdsPartitionOperationException;

   /**
    * Synchronizes replicas, restricted by the specified time delay.
    *
    * <p>This syncReplica() method updates each replica of a partition
    * after an addition, deletion, or modification to NDS by providing 
    * a wrapper for the NWDSSyncPartition function.
    *
    * @param delay Time delay after which to start the synchronization
    *              process.
    *
    * @exception PartitionOperationException Naming Exception indicating
    *                                        that the operation failed.
    */
   public void syncReplica (
         int delay)
      throws NdsPartitionOperationException;

   /**
    * This replica receives updates from the master replica.
    *
    * @exception NSIException
    */
   public void receiveUpdates ()
      throws NSIException;

   /**
    * This replica sends updates to all other replicas.
    *
    * @exception NSIException
    */
   public void sendUpdates ()
      throws NSIException;

}


