/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/nds/ldap/LdapTelephoneNumber.java $
  $Revision: 1 $
  $Modtime: 3/02/98 1:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nds.ldap;

import com.novell.service.nds.*;

/**
@internal
LdapTelephoneNumber is an Adapter for NdsTelephoneNumber.
*/
public final class LdapTelephoneNumber
   extends NdsTelephoneNumber
   implements LdapAttributeValue
{

   /**
   * Constructs an LdapTelephoneNumber adapter for an NdsTelephoneNumber.
   *
   * @param   value     Ldap string representation of TelephoneNumber.
   */
   protected LdapTelephoneNumber (
         String value)
   {
      this.value = new String(value);
   }

   /**
   * Constructs an LdapTelephoneNumber adapter for an NdsTelephoneNumber.
   *
   * @param   value     an NdsTelephoneNumber object.
   */
   protected LdapTelephoneNumber (NdsTelephoneNumber value)
   {
      super (value);
   }

   /**
   * Returns an Ldap string representation of TelephoneNumber.
   *
   * @return   String containing Ldap string representation of TelephoneNumber.
   */
   public String toString ()
   {
      return this.value;
   }
}

