
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/NdsNameUtility.java $
  $Revision: 10 $
  $Modtime: 4/13/00 10:18a $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming;


import java.util.Vector;

import javax.naming.Name;
import javax.naming.InvalidNameException;

import com.novell.service.jncpv2.net.NetService;

import com.novell.utility.naming.Syntax;


/** @internal
 * The implementation class for CompoundName and CompositeName.
 * This class is package private.
 */
class NdsNameUtility
{
   private String syntaxSeparator;
   private String syntaxEscape;
   private String syntaxBeginQuote1;
   private String syntaxEndQuote1;
   private String syntaxAvaSeparator;
   private String syntaxTypevalSeparator;

   /**
    *
    */
   public NdsNameUtility (
         Syntax syntax)
   {
      syntaxSeparator = syntax.getSeparator ();
      syntaxEscape = syntax.getEscape ();
      syntaxBeginQuote1 = syntax.getBeginQuote ();
      syntaxEndQuote1 = syntax.getEndQuote ();
      syntaxAvaSeparator = syntax.getAvaSeparator ();
      syntaxTypevalSeparator = syntax.getTypevalSeparator ();

   } /* NdsNameUtility */

   /**
    *
    */
   protected final int stringToComponent (
         String name,
         int i,
         int len,
         Vector comps)
      throws InvalidNameException
   {
      boolean start = true;
      StringBuffer answer = new StringBuffer (len);

      while (i < len)
      {
/*
         // The following code is commented out since we were having
			// problems with names like: "A" Insurance agencies inc.users.utah
			// If by chance we decide to put this code back in, cases such as
			// this should be considered.
			// Thur 4/13/00 sem
			
         // handle quoted strings
         if (start && name.startsWith (syntaxBeginQuote1, i))
         {
            i += syntaxBeginQuote1.length ();

            // consume string until matching quote
            while ((i < len) && !name.startsWith (syntaxEndQuote1, i))
            {
               // skip escape character if it is escaping ending quote
               // otherwise leave as is.
               if (name.startsWith (syntaxEscape, i) 
                  && name.startsWith (syntaxEndQuote1, i + syntaxEscape.length ()))
               {
                  i += syntaxEscape.length ();
               }
               answer.append (name.charAt (i++));  // copy char
            }

            // no ending quote found
            if (i >= len)
            {
               throw new InvalidNameException (name);
            }

            i += syntaxEndQuote1.length ();

            // verify that end-quote occurs at separator or end of string
            if (i == len || name.startsWith (syntaxSeparator, i))
            {
               i += syntaxSeparator.length ();
               break;
            }
            throw (new InvalidNameException (name));
         }
*/			
         if (name.startsWith (syntaxSeparator, i))
         {
            if (start)
            {
               // un-escaped separator at start of component
               throw (new InvalidNameException (name));
            }
            else if (i + syntaxSeparator.length () >= len)
            {
               // un-escaped separator at end of component
               throw (new InvalidNameException (name));
            }
            i += syntaxSeparator.length ();
            break;
         }
         else if (name.startsWith (syntaxEscape, i))
         {
            answer.append (syntaxEscape);
				start = false;

            if ((i += syntaxEscape.length ()) >= len)
            {
               // escape at end of component
               throw (new InvalidNameException (name));
            }

            if (name.startsWith (syntaxSeparator, i))
            {
               answer.append (syntaxSeparator);
               i += syntaxSeparator.length ();
            }
            else if (name.startsWith (syntaxEscape, i))
            {
               answer.append (syntaxEscape);
               i += syntaxEscape.length ();
            }
            else if (name.startsWith (syntaxTypevalSeparator, i))
            {
               answer.append (syntaxTypevalSeparator);
               i += syntaxTypevalSeparator.length ();
            }
            else if (name.startsWith (syntaxAvaSeparator, i))
            {
               answer.append (syntaxAvaSeparator);
               i += syntaxAvaSeparator.length ();
            }
            else
            {
               // invalid escape sequence
               throw (new InvalidNameException (name));
            }
            continue;
         }
         answer.append (name.charAt (i++));
         start = false;
      }

      comps.insertElementAt (answer.toString(), 0);

      return (i);

   } /* stringToComponent () */

} /* NdsNameUtility */


