
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/local/SchemaContextFactory.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.local;


import java.util.Hashtable;
import java.util.Properties;

import java.lang.reflect.*;

import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.spi.ObjectFactory;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.naming.NdsEnvironment;
import com.novell.service.nds.naming.NdsDataAccessor;
import com.novell.service.nds.naming.Schema;
import com.novell.service.nds.naming.TransportContextFactoryBuilder;

import com.novell.utility.naming.Environment;
import com.novell.utility.naming.spi.ContextFactory;
import com.novell.utility.naming.spi.ContextFactoryBuilder;


/** @internal
 *
 */
public class SchemaContextFactory implements ContextFactory
{
   private static ContextFactoryBuilder builder;

   private static String defaultClass;
   private static Properties wrapperClasses;


   static
   {
      builder = new TransportContextFactoryBuilder ();

      defaultClass = "com.novell.service.nds.naming.local.SchemaDirContext";
      wrapperClasses = new Properties ();

      wrapperClasses.put (
               Schema.ATTRIBUTE_CONTAINER,
               "com.novell.service.nds.naming.local.AttributeContainerDirContext");
      wrapperClasses.put (
               Schema.CLASS_CONTAINER,
               "com.novell.service.nds.naming.local.ClassContainerDirContext");
      wrapperClasses.put (
               Schema.SCHEMA_ATTRIBUTE,
               "com.novell.service.nds.naming.local.SchemaAttributeDirContext");
      wrapperClasses.put (
               Schema.SCHEMA_CLASS,
               "com.novell.service.nds.naming.local.SchemaClassDirContext");
      wrapperClasses.put (
               Schema.SCHEMA_CONTAINER,
               "com.novell.service.nds.naming.local.SchemaContainerDirContext");
      wrapperClasses.put (
               Schema.SCHEMA_SYNTAX,
               "com.novell.service.nds.naming.local.SchemaSyntaxDirContext");
      wrapperClasses.put (
               Schema.SYNTAX_CONTAINER,
               "com.novell.service.nds.naming.local.SyntaxContainerDirContext");

   } /* static */


   /**
    *
    */
   public SchemaContextFactory ()
   {

   }


   /**
    * Returns Nds 'wrapped' contexts
    */
   public Object getObjectInstance (
         Object object,
         Name name,
         Context nameCtx,
         Hashtable environment)
      throws Exception
   {
      NdsEnvironment ndsEnvironment = new NdsEnvironment (environment);

      if (object instanceof Reference)
      {
         StringRefAddr address;
         CompositeName value;

         address = (StringRefAddr) ((Reference) object).get (0);
         value = new CompositeName ((String) address.getContent ());

         // component 0 holds url
         environment.put (Context.PROVIDER_URL, value.get (0));

         // component 1 holds fdn
         return (getContextInstance (value.get (1), ndsEnvironment));
      }

      if (object instanceof String)
      {
         return (getContextInstance ((String) object, ndsEnvironment));
      }

      if (object instanceof CompoundName)
      {
         return (getContextInstance (object.toString (), ndsEnvironment));
      }
      throw (new Exception ());

   } /* createObject () */

   /**
    *
    */
   public Context getContextInstance (
         String contextName,
         Environment environment)
      throws NamingException
   {
      return (getContextInstance (contextName, null, environment));

   } /* getContextInstance () */

   /**
    *
    */
   public Context getContextInstance (
         String contextName,
         Object classInfo,
         Environment environment)
      throws NamingException
   {
      Context context;
      ContextFactory factory;
      NdsEnvironment ndsEnvironment = getEnvironmentInstance (environment);

      // Create transport specific factory
      factory = builder.createContextFactory (contextName, ndsEnvironment);

      // Get transport specific context
      context = factory.getContextInstance (contextName, ndsEnvironment);

      // Wrap with local NdsContext
      return (getContextInstance (context));

   } /* getContextInstance () */

   /**
    *
    */
   public Context getContextInstance (
         Object context)
      throws NamingException
   {
      if (!(context instanceof NdsDataAccessor))
      {
         throw (new NamingException ());
      }

      NdsDataAccessor ndsAccessor = (NdsDataAccessor) context;

      try
      {
         Class cls;
         Class [] argTypes = new Class [2];
         Constructor ctor;
         Object [] args = new Object [2];

         cls = Class.forName (getClassName (ndsAccessor));

         argTypes [0] = Class.forName (
            "com.novell.service.nds.naming.SchemaDirContextWrappable");
         argTypes [1] = Class.forName (
            "com.novell.service.nds.naming.NdsEnvironment");
         ctor = cls.getDeclaredConstructor (argTypes);

         args [0] = ndsAccessor;
         args [1] = ndsAccessor.getEnvironmentInstance ();

         return ((Context) ctor.newInstance (args));
      }
      catch (ClassNotFoundException e)
      {
         NamingException ne = new NamingException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (SecurityException e)
      {
         NamingException ne = new NamingException ();
         ne.setRootCause (e);
         throw (ne);
      }
      catch (NoSuchMethodException e)
      {
         NamingException ne = new NamingException ();
         ne.setRootCause (e);
         throw (ne);
      }
      catch (InstantiationException e)
      {
         NamingException ne = new NamingException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (IllegalAccessException e)
      {
         NamingException ne = new NamingException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (IllegalArgumentException e)
      {
         NamingException ne = new NamingException ();
         ne.setRootCause (e);
         throw (ne);
      }
      catch (InvocationTargetException e)
      {
         NamingException ne = new NamingException ();
         ne.setRootCause (e);
         throw (ne);
      }

   } /*  */

   /**
    *
    */
   public String getClassName (
         Object object)
      throws NamingException
   {
      try
      {
         String baseClass;

         if (object instanceof NdsDataAccessor)
         {
            baseClass = ((NdsDataAccessor) object).getBaseClass ();
         }
         else if (object instanceof String)
         {
            baseClass = (String) object;
         }
         else
         {
            throw (new NamingException ());
         }

         return (wrapperClasses.getProperty (baseClass, defaultClass));
      }
      catch (NSIException e)
      {
         throw (new NamingException ());
      }

   } /* getClassName () */

   /**
    *
    */
   private NdsEnvironment getEnvironmentInstance (
         Environment environment)
      throws NamingException
   {
      if (environment instanceof NdsEnvironment)
      {
         return ((NdsEnvironment) environment);
      }
      return (new NdsEnvironment (environment));

   } /* getEnvironmentInstance () */

} /* SchemaContextFactory */


