
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/NetDirectoryMapDirContext.java $
  $Revision: 14 $
  $Modtime: 5/08/00 6:19p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.util.Properties;
import java.util.Hashtable;

import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.spi.*;

import com.novell.service.file.nw.naming.FSEnvironment;

import com.novell.service.nds.*;
import com.novell.service.nds.naming.*;

import com.novell.service.schema.SchemaString;

import com.novell.service.jncp.*;
import com.novell.service.jncpv2.net.*;

import com.novell.service.session.*;

import com.novell.utility.naming.Environment;
import com.novell.utility.naming.spi.ReferenceFactory;


/** @internal
 *
 */
public class NetDirectoryMapDirContext extends NetDirContext
{
   private Object nnsp;

   /**
    *
    */
   protected NetDirectoryMapDirContext (
         String objectName,
         NdsObjectInfo objectInfo,
         NetEnvironment environment)
      throws NamingException
   {
      super (objectName, objectInfo, environment);
   }


   // ******************** NDSComponentDirContext methods ********************

   /**
    *
    */
   protected Object getNNSP ()
      throws NamingException
   {
      if (null == nnsp)
      {
         try
         {
            Class cls;
            Hashtable properties;
            StringBuffer providerURL = new StringBuffer (1024);
            ReferenceFactory referenceFactory;
            Reference reference;

            // Guarantee NDS server session
            Session session = getHostServerSession ();

            cls = Class.forName ("com.novell.service.file.nw.naming.ReferenceFactoryImpl");
            referenceFactory = (ReferenceFactory) cls.newInstance ();

            properties = environment.getEnvironment ();

            // set INITIAL_CONTEXT_FACTORY to FileSystemInitialContextFactory
            properties.put (
                                 Context.INITIAL_CONTEXT_FACTORY,
                                 Environment.FS_INITIAL_CONTEXT_FACTORY);

            // set PROVIDER_URL to <ServerName>/<VolumeName>/<PathName>
            providerURL.append (getServerName ());
            providerURL.append ("/");
            providerURL.append (getHostResourceName ());
            providerURL.append ("/");
            providerURL.append (getPath ());

            properties.put (
                           Context.PROVIDER_URL,
                           new String (providerURL));

            // set SESSION_OBJECT to NDS Server Session
            properties.put (Environment.SESSION_OBJECT, session);

            reference = referenceFactory.createReference (properties);

            nnsp = NamingManager.getObjectInstance (reference, null, null, properties);
         }
         catch (Exception e)
         {
            // nnsp remains null
         }
      }
      return (nnsp);
   }


   // ******************* NetDirectoryMapDirContext class *******************

   /**
    *
    * The server name is the last component of the "Host Server" attribute
    * value.  The component has also had types removed.
    */
   private String getServerName ()
      throws NamingException
   {
      Name target;

      target = ((NdsName) nameParser.parse (getHostServer ())).getTypelessName ();
      return (target.get (target.size () - 1));
   }

   /**
    *
    */
   private String getHostServer ()
      throws NamingException
   {
      Attributes attrs;
      SchemaString hostServer;

      attrs = getAttributes ("", new String[] {"Host Server"});
      hostServer = (SchemaString) attrs.get ("Host Server").get ();
      return (hostServer.stringValue ());
   }

   /**
    *
    */
   private Session getHostServerSession ()
      throws NamingException, SessionException
   {
      SessionManager manager = environment.getSessionManager ();
      Session session = manager.findSession (getTreeName ());

      return (session.getSession (getHostServer ()));
   }

   /**
    *
    */
   private String getHostResourceName ()
      throws NamingException
   {
      Context context;

      context = factory.getContextInstance (getVolumeName (), environment);
      return (((NetVolumeDirContext) context).getHostResourceName ());
   }

   /**
    *
    */
   private String getVolumeName ()
      throws NamingException
   {
      Attributes attrs;
      NdsPath path;

      attrs = getAttributes ("", new String[] {"Path"});
      path = (NdsPath) attrs.get ("Path").get ();
      return (path.getVolumeName ());

   } /* getVolumeName () */

   /**
    *
    */
   private String getPath ()
      throws NamingException
   {
      Attributes attrs;
      NdsPath path;

      attrs = getAttributes ("", new String[] {"Path"});
      path = (NdsPath) attrs.get ("Path").get ();
      return (path.getPath ());

   } /* getPath () */

} /* DirectoryMapComponentDirContext */


