
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/NetEntryAttributes.java $
  $Revision: 7 $
  $Modtime: 6/02/00 9:57a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.util.*;

import javax.naming.*;
import javax.naming.directory.*;

import com.novell.service.jncp.*;

import com.novell.service.nds.*;
import com.novell.service.nds.net.*;
import com.novell.service.nds.naming.*;

import com.novell.service.session.SessionException;
import com.novell.service.jncpv2.net.*;


/** @internal
 *
 */
public class NetEntryAttributes extends BasicAttributes
{
   private static String[] allAttributeNames = 
      {
         NetEntryAttributeId.ENTRY_ID,
         NetEntryAttributeId.ENTRY_FLAGS,
         NetEntryAttributeId.SUBORDINATE_COUNT,
         NetEntryAttributeId.MODIFICATION_TIME,
         // not supported
//         NetEntryAttributeId.MODIFICATION_TIMESTAMP,
         // not supported
//         NetEntryAttributeId.CREATION_TIMESTAMP,
         NetEntryAttributeId.PARTITION_ROOT_ID,
         NetEntryAttributeId.PARENT_ID,
         NetEntryAttributeId.REVISION_COUNT,
         NetEntryAttributeId.REPLICA_TYPE,
         NetEntryAttributeId.BASE_CLASS,
         NetEntryAttributeId.ENTRY_RDN,
         NetEntryAttributeId.ENTRY_DN,
         NetEntryAttributeId.PARTITION_ROOT_DN,
         NetEntryAttributeId.PARENT_DN,
         NetEntryAttributeId.PURGE_TIME,
         NetEntryAttributeId.DEREFERENCE_BASE_CLASS,
         NetEntryAttributeId.FEDERATION_BOUNDARY,
         NetEntryAttributeId.SCHEMA_BOUNDARY
      };


   private static NdsNamingExceptionFactory exceptionFactory =
          new NdsNamingExceptionFactory ();


   private String objectName;
   private NetEnvironment environment;
   private NetService service;

   private NetEntryInfo entryInfo;


   /**
    *
    */
   public NetEntryAttributes (
         String objectName,
         String[] attributeNames,
         NetEnvironment environment)
      throws NamingException
   {
      this.objectName = objectName;
      this.environment = environment;
      this.service = environment.getService ();

      if (null == attributeNames)
      {
         attributeNames = allAttributeNames;
      }

      try
      {
         getEntryInfo ();
      }
      catch (NSIException e)
      {
         throw (exceptionFactory.getNamingException (e));
      }

      for (int i = 0; i < attributeNames.length; i++)
      {
         Integer flag;

         flag = NetEntryAttributeId.getEntryInfoFlag (attributeNames[i]);

         if (flag != null)
         {
            NdsAttributeValue attributeValue;

            attributeValue = createValue (flag.intValue ());

            super.put (new BasicAttribute (attributeNames[i], attributeValue));
         }
      }

   } /* NetEntryAttributes () */

   /**
    *
    */
   private void getEntryInfo ()
      throws NSIException
   {
      try
      {
         entryInfo = service.readEntry (
                                          objectName,
                                          environment.getBatchSize ());
      }
      catch (SessionException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }

   } /* getEntryInfo () */

   /**
    *
    */
   private NdsAttributeValue createValue (
         int infoFlag)
      throws NSIException
   {
      switch (infoFlag)
      {
         case NetJNI.DSI_ENTRY_ID:
         {
            return (new NdsInteger (entryInfo.getEntryId ()));
         }
         case NetJNI.DSI_ENTRY_FLAGS:
         {
            return (new NdsInteger (entryInfo.getEntryFlags ()));
         }
         case NetJNI.DSI_SUBORDINATE_COUNT:
         {
            return (new NdsInteger (entryInfo.getSubordinateCount ()));
         }
         case NetJNI.DSI_PARTITION_ROOT_ID:
         {
            return (new NdsInteger (entryInfo.getPartitionRootId ()));
         }
         case NetJNI.DSI_PARENT_ID:
         {
            return (new NdsInteger (entryInfo.getParentId ()));
         }
         case NetJNI.DSI_REVISION_COUNT:
         {
            return (new NdsInteger (entryInfo.getRevisionCount ()));
         }
         case NetJNI.DSI_REPLICA_TYPE:
         {
            return (new NdsInteger (entryInfo.getReplicaType ()));
         }

         case NetJNI.DSI_MODIFICATION_TIME:
         {
            return (new NdsTime (entryInfo.getModificationTime ()));
         }
         case NetJNI.DSI_PURGE_TIME:
         {
            return (new NdsTime (entryInfo.getPurgeTime ()));
         }

         case NetJNI.DSI_BASE_CLASS:
         {
            return (new NdsCaseIgnoreString (entryInfo.getBaseClass ()));
         }
         case NetJNI.DSI_ENTRY_RDN:
         {
            return (new NdsCaseIgnoreString (entryInfo.getEntryRDN ()));
         }
         case NetJNI.DSI_ENTRY_DN:
         {
            return (new NdsCaseIgnoreString (entryInfo.getEntryDN ()));
         }
         case NetJNI.DSI_PARTITION_ROOT_DN:
         {
            return (new NdsCaseIgnoreString (entryInfo.getPartitionRootDN ()));
         }
         case NetJNI.DSI_PARENT_DN:
         {
            return (new NdsCaseIgnoreString (entryInfo.getParentDN ()));
         }
         case NetJNI.DSI_DEREFERENCE_BASE_CLASS:
         {
            return (new NdsCaseIgnoreString (entryInfo.getDereferenceBaseClass ()));
         }

         case NetJNI.DSI_MODIFICATION_TIMESTAMP:
         {
//            return (new NdsTimestamp (entryInfo.));
         }
         case NetJNI.DSI_CREATION_TIMESTAMP:
         {
//            return (new NdsTimestamp (entryInfo.));
         }
         case NetJNI.DSI_FEDERATION_BOUNDARY:
         {
            return (new NdsCaseIgnoreString (entryInfo.getFederationBoundary ()));
         }
         case NetJNI.DSI_SCHEMA_BOUNDARY:
         {
            return (new NdsCaseIgnoreString (entryInfo.getSchemaBoundary ()));
         }

         default:
         {
            throw (new NSIException ());
         }

      } /* switch (syntaxID) */

    } /* createValue () */

} /* NetEntryAttributes */


