
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/NetJavaContainerDirContext.java $
  $Revision: 4 $
  $Modtime: 1/25/00 4:40p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.spi.*;

import com.novell.service.nds.NdsObjectInfo;
import com.novell.service.nds.naming.NdsName;

import com.novell.service.jncpv2.net.NetObjectInfo;


/**@internal
 *
 */
public class NetJavaContainerDirContext extends NetDirContext
{
   /**
    *
    */
   protected NetJavaContainerDirContext (
         String objectName,
         NdsObjectInfo objectInfo,
         NetEnvironment netEnvironment)
      throws NamingException
   {
      super (objectName, objectInfo, netEnvironment);
   }


   // ****************** NetJavaContainerDirContext Class ******************

   /**
    *
    */
   protected Object decodeObject ()
      throws NamingException
   {
      try
      {
         Object object;
         Attributes attrs;

         attrs = new NetAttributes (
                        getNameInstance ().getCanonicalString (),
                        environment,
                        null);

         object = JavaObject.decodeObject (attrs);

         if (object instanceof Reference)
         {
            return (NamingManager.getObjectInstance (
                                       object,
                                       getNameInstance (),
                                       this,
                                       environment.getEnvironment (true)));
         }
         return (object);

      }
      catch (Exception e)
      {
         NamingException ne = new NamingException ();
         ne.setRootCause (e);
         throw (ne);
      }

   } /* decodeObject () */


} /* NetJavaContainerDirContext */


