
/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/nds/naming/net/NetReplicaAttributes.java $
  $Revision: 2 $
  $Modtime: 4/23/98 1:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;

import javax.naming.*;
import javax.naming.directory.*;
import java.util.*;

import com.novell.service.nds.NdsReplicaPointer;
import com.novell.service.nds.naming.*;

import com.novell.utility.naming.directory.NAttributes;

/** @internal
 *
 * public class NDSAttributes
 *     extends Attributes
 */

public class NetReplicaAttributes extends NAttributes
{

   //* **********************************************************************
   // Private Instance Variables
   //************************************************************************

   private static String[] attrNames = {
                 NdsPartitionStrings.REPLICA_ATTRID_NAME,
                 NdsPartitionStrings.REPLICA_ATTRID_TYPE,
                 NdsPartitionStrings.REPLICA_ATTRID_STATE,
                 NdsPartitionStrings.REPLICA_ATTRID_NUMBER,
                 NdsPartitionStrings.REPLICA_ATTRID_ADDRESS_HINTS,
                 NdsPartitionStrings.REPLICA_ATTRID_SERVER_READ,
                 NdsPartitionStrings.REPLICA_ATTRID_PARTITION_NAME,
                 NdsPartitionStrings.REPLICA_ATTRID_LAST_SUCCESSFUL_SYNC_TIME,
                 NdsPartitionStrings.REPLICA_ATTRID_SYNC_ERROR,
//                 NdsPartitionStrings.REPLICA_ATTRID_SERVER_OS_NAME,
//                 NdsPartitionStrings.REPLICA_ATTRID_SERVER_HARDWARE_NAME,
//                 NdsPartitionStrings.REPLICA_ATTRID_SERVER_VENDOR_NAME,
//                 NdsPartitionStrings.REPLICA_ATTRID_SERVER_DIRECTORY_NAME,
//                 NdsPartitionStrings.REPLICA_ATTRID_SERVER_DIRECTORY_VERSION,
                 NdsPartitionStrings.REPLICA_ATTRID_SERVER_NAME,
//                 NdsPartitionStrings.REPLICA_ATTRID_SERVER_VERSION,
                 NdsPartitionStrings.REPLICA_ATTRID_SERVER_ADDRESSES,
                 NdsPartitionStrings.REPLICA_ATTRID_SERVER_SYNC_TIME_UNIT,
//                 NdsPartitionStrings.REPLICA_ATTRID_SERVER_LICENSE_ID,
                 NdsPartitionStrings.REPLICA_ATTRID_SERVER_BUSY,
                 NdsPartitionStrings.REPLICA_ATTRID_SERVER_MODIFICATION_TIME };

    private static Hashtable mapAttrset = null;
    private PartitionFunctions pf;



   //* **********************************************************************
   // Protected Constructors
   //************************************************************************


   public NetReplicaAttributes (
            String replicaName,
            String partnName,
            NetEnvironment netEnv,
            String[] attrIDs)
        throws AttributeInUseException, NamingException
   {
      super();

      if(mapAttrset == null)
      {
          mapAttrset = new Hashtable();
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_NUMBER.toUpperCase (),
                NdsPartitionStrings.REPLICA_POINTER_INFO);
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_TYPE.toUpperCase (),
                NdsPartitionStrings.REPLICA_POINTER_INFO);
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_STATE.toUpperCase (),
                NdsPartitionStrings.REPLICA_POINTER_INFO);
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_ADDRESS_HINTS.toUpperCase (),
                NdsPartitionStrings.REPLICA_POINTER_INFO);

          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_READ.toUpperCase (),
                NdsPartitionStrings.REPLICA_SERVER_INFO);

          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_LAST_SUCCESSFUL_SYNC_TIME.toUpperCase (),
                NdsPartitionStrings.REPLICA_SYNC_INFO);
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_SYNC_ERROR.toUpperCase (),
                NdsPartitionStrings.REPLICA_SYNC_INFO);

          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_OS_NAME.toUpperCase (),
                NdsPartitionStrings.REPLICA_SERVER_INFO);
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_HARDWARE_NAME.toUpperCase (),
                NdsPartitionStrings.REPLICA_SERVER_INFO);
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_VENDOR_NAME.toUpperCase (),
                NdsPartitionStrings.REPLICA_SERVER_INFO);
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_DIRECTORY_NAME.toUpperCase (),
                NdsPartitionStrings.REPLICA_SERVER_INFO);
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_DIRECTORY_VERSION.toUpperCase (),
                NdsPartitionStrings.REPLICA_SERVER_INFO);
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_NAME.toUpperCase (),
                NdsPartitionStrings.REPLICA_SERVER_INFO);
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_VERSION.toUpperCase (),
                NdsPartitionStrings.REPLICA_SERVER_INFO);
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_ADDRESSES.toUpperCase (),
                NdsPartitionStrings.REPLICA_SERVER_INFO);
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_SYNC_TIME_UNIT.toUpperCase (),
                NdsPartitionStrings.REPLICA_SERVER_INFO);
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_LICENSE_ID.toUpperCase (),
                NdsPartitionStrings.REPLICA_SERVER_INFO);
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_MODIFICATION_TIME.toUpperCase (),
                NdsPartitionStrings.REPLICA_SERVER_INFO);
          mapAttrset.put(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_BUSY.toUpperCase (),
                NdsPartitionStrings.REPLICA_SERVER_INFO);
      }

      NdsReplicaPointer rpi = null;
      NetReplicaSyncInfo rsyi = null;
      NetReplicaServerInfo rsi = null;

      pf = new PartitionFunctions(netEnv);

      // Create an attribute set for the IDs passed in
      if(null != attrIDs)
      {
         // Go over the attrs hash table to determine which all objects
         // need to be retrieved
         for(int i = 0; i < attrIDs.length; i++)
         {
            String set = (String)mapAttrset.get(attrIDs[i].toUpperCase ());

            if(set != null)
            {
               if(set.equals(NdsPartitionStrings.REPLICA_POINTER_INFO))
               {
                  if(rpi == null)
                  {
                     rpi = pf.getReplicaInfo(partnName, replicaName);
                  }
               }
               else if(set.equals(NdsPartitionStrings.REPLICA_SYNC_INFO))
               {
                  if(rsyi == null)
                  {
                     rsyi = pf.getReplicaSyncInfo(partnName, replicaName);
                  }
               }
               else if(set.equals(NdsPartitionStrings.REPLICA_SERVER_INFO))
               {
                  if(rsi == null)
                  {
                     rsi = pf.getReplicaServerInfo(partnName, replicaName);
                  }
               }
            }
            put(new NetReplicaAttribute(
                        replicaName,
                        partnName,
                        netEnv,
                        attrIDs[i],
                        rpi,
                        rsyi,
                        rsi));

         }
      }
      else
      {
          rpi = pf.getReplicaInfo(partnName, replicaName);
          rsyi = pf.getReplicaSyncInfo(partnName, replicaName);
          rsi = pf.getReplicaServerInfo(partnName, replicaName);

         // Add all the attributes
         for(int i = 0; i < attrNames.length; i++)
         {
            put(new NetReplicaAttribute(
                        replicaName,
                        partnName,
                        netEnv,
                        attrNames[i],
                        rpi,
                        rsyi,
                        rsi));
         }
      }
   }
   public boolean IsCaseIgnored()
   {
        return true;
   }
}


