
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/net/NetReplicaNameClassEnumerator.java $
  $Revision: 9 $
  $Modtime: 1/31/00 11:29a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.util.*;

import javax.naming.*;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.*;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.net.NetAttributeValueFactory;

import com.novell.service.jncpv2.net.NetService;


/** @internal
 *
 */
public class NetReplicaNameClassEnumerator implements NamingEnumeration
{
   private String partitionName;
   private static NdsNamingExceptionFactory exceptionFactory =
       new NdsNamingExceptionFactory ();

   NetService service;

   NetAttributeValueEnumerator rawValues;

   /**
    *
    */
   public NetReplicaNameClassEnumerator (
         NetEnvironment env,
         String partitionName)
      throws NamingException
   {
      this.partitionName = partitionName;
      this.service = env.getService ();
      try
      {
         this.rawValues = new NetAttributeValueEnumerator (
                  service,
                  partitionName, 
                  "Replica");
      }
      catch (NSIException e) 
      {
			NamingException ne = exceptionFactory.getNamingException (e);
         throw (ne);
      }
   }

   /**
    * Tests if this enumeration contains more elements.
    */
   public boolean hasMoreElements ()
   {
      return this.rawValues.hasMoreElements();
   }

   /**
    * Returns the next element of this enumeration.
    *
    * @exception NoSuchElementException
    */
   public Object nextElement ()
      throws NoSuchElementException
   {
      try 
      {
         NdsReplicaPointer replicaPointer = null;

         replicaPointer = (NdsReplicaPointer)
               NetAttributeValueFactory.createValue(
                        NdsSyntaxId.REPLICA_POINTER_ID,
                        (byte[]) this.rawValues.nextElement (),
                        null,
                        null,
                        partitionName,
                        "Replica");

         return (new NameClassPair(
                        replicaPointer.getServerName(),
                        "NdsReplicaDirContext"));
      }
      catch (NSIException e)
      {
         throw new NoSuchElementException(e.getMessage());
      }

   } /* nextElement () */

    /**
     * Tests if this enumeration contains more elements.
     */
   public boolean hasMore ()
   {
      return this.hasMoreElements();
   }

    /**
     * Returns the next element of this enumeration.
     *
     * @exception NamingException
     */
   public Object next ()
       throws NamingException
   {
      return (this.nextElement ());
   }

   /**
    *
    */
   public void close ()
      throws NamingException
   {
		rawValues.closeIteration();
   }

}


