
/* **************************************************************************
  $Archive: /njcl_v2/src/com/novell/service/nds/net/NetInteger.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsInteger;


/** @internal
 * NetInteger is an Adapter for NdsInteger.
 *
 * This class converts to/from the NWNet Integer_T.
 *
 * API Data Structure:
 *    typedef nint32 Integer_T;
 */
public final class NetInteger
   extends NdsInteger implements NetAttributeValue, Serializable
{
   /**
    * Constructs an Integer from the "API Data Structure".
    *
    * @param   value   byte[] containing a Integer_T
    */
   protected NetInteger (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream edis = new EndianInputStream (value);

         this.value = edis.readLoHiInt ();
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetInteger adapter for an NdsInteger.
    *
    * @param   value   an NdsInteger object.
    */
   protected NetInteger (
         NdsInteger value)
   {
      super (value);
   }

   /**
    * Returns a Integer "API Data Structure".
    *
    * @return   byte[] containing Integer_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiInt (this.value);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetInteger */


