
/* **************************************************************************
  $Archive: /njcl_v2/src/com/novell/service/nds/net/NetUnknown.java $
  $Revision: 6 $
  $Modtime: 1/28/00 12:46p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsUnknown;


/** @internal
 * NetUnknown is an Adapter for NdsUnknown.
 *
 * This class converts to/from the NWNet Unknown_Attr_T.
 * 
 * API Data Structure:
 *    typedef struct
 *    {
 *       pnchar         attrName;
 *       NWSYNTAX_ID    syntaxID;
 *       NWLEN          valueLen;
 *       void          *value;
 *
 *    } Unknown_Attr_T;
 */
public final class NetUnknown
   extends NdsUnknown implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Unknown from the "API Data Structure".
    * 
    * @param   value   byte[] containing a Unknown_Attr_T
    */
   protected NetUnknown (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream edis = new EndianInputStream (value);

         this.attributeName = edis.readLoHiChars ();
         this.syntaxId = edis.readLoHiInt ();
         this.value = new byte[edis.readLoHiInt ()];
         edis.readFully (this.value);
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetUnknown adapter for an NdsUnknown.
    * 
    * @param   value   an NdsUnknown object.
    */
   protected NetUnknown (
         NdsUnknown value)
   {
      super (value);
   }

   /**
    * Returns a Unknown "API Data Structure".
    * 
    * @return   byte[] containing Unknown_Attr_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiChars (this.attributeName);
         eos.writeLoHiInt (this.syntaxId);
         eos.writeLoHiInt (this.value.length);
         eos.write (this.value);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetUnknown */


