/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nw/NamesEnumeratorFactory.java $
  $Revision: 5 $
  $Modtime: 1/28/00 12:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nw;

import java.util.*;
import com.novell.service.jncp.*;
import com.novell.service.session.*;
import com.novell.service.session.xplat.CallsService;
import com.novell.service.session.xplat.Xplat;

/**
*  Returns a SLP or Bindery enumerator based on the availability of SLP calls
*/
class NamesEnumeratorFactory
{
   public static final int SERVERS = Xplat.NW_SERVER_TYPE;
   public static final int TREES = Xplat.NDS_TREE_TYPE;

   static public Enumeration getNamesEnumerator(int type, Hashtable h)
   {
      try
      {
         Session s = (Session)h.get(com.novell.utility.naming.Environment.SESSION_OBJECT);
         CallsService service = (CallsService)s.getService(CallsService.KEY);
         if(service.areSLPCallsAvailable())
            return new SLPNamesEnumerator(type, h);
         else if(type == TREES)
            return new BinderyTreeNamesEnumerator(h);
         else
            return new BinderyServerNamesEnumerator(h);
      }
      catch(Exception e)
      {
         throw NSIExceptionBuilder.build(e);
      }
   }

   static public void closeEnumerator(Enumeration enum)
   {
      if(enum instanceof SLPNamesEnumerator)
         ((SLPNamesEnumerator)enum).close();
   }
}
