/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/qms/NWQueueJob.java $
  $Revision: 8 $
  $Modtime: 11/16/99 10:41a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.qms;

import java.util.*;

/** @internal
 * This is an implementation class that represents the queue job data
 * structure.
 */

public class NWQueueJob
{
   // Private Instance Variables =============================================
   private int      clientStation;
   private int      clientTask;
   private int      clientID;
   private int      targetServerID;
   private Date     targetExecutionTime;
   private Date     jobEntryTime;
   private int      jobNumber;
   private int      jobType;
   private int      jobPosition;
   private int      jobControlFlags;
   private byte[]   jobFileName;
   private int      jobFileHandle;
   private int      servicingServerStation;
   private int      servicingServerTask;
   private int      servicingServerID;
   private String   jobDescription;
   private byte[]   clientRecordArea;

   // Public Constructors ====================================================

   public NWQueueJob()
   {
      this.clientStation = 0;
      this.clientTask = 0;
      this.clientID = 0;
      this.targetServerID = -1;

      byte[] tmpExecutionTime = { -1, -1, -1, -1, -1, -1 };
      this.jobEntryTime = new Date();
      this.targetExecutionTime = new Date( jobEntryTime.getTime() );
      this.jobNumber = 0;
      this.jobType = 0;
      this.jobPosition = 0;
      this.jobControlFlags = 0;
      this.jobFileName = new byte[14];
      this.jobFileHandle = 0;
      this.servicingServerStation = 0;
      this.servicingServerTask = 0;
      this.jobDescription = new String();
      this.clientRecordArea = new byte[152];
   }

   // Public Instance Methods ================================================

   public void setClientStation (
         int clientStation)
   {
      this.clientStation = clientStation;
   }

   public void setClientTask (
         int clientTask)
   {
      this.clientTask = clientTask;
   }

   public void setClientID (
         int clientID)
   {
      this.clientID = clientID;
   }

   public void setTargetServerID (
         int targetServerID)
   {
      this.targetServerID = targetServerID;
   }
    
   public void setTargetExecutionTime (
         byte[] targetExecutionTime)
   {
      if ( targetExecutionTime.length < 6 )
      {
         // throw an exception
      }

      if ((-1 == targetExecutionTime[0]) && 
          (-1 == targetExecutionTime[1]) && 
          (-1 == targetExecutionTime[2]) && 
          (-1 == targetExecutionTime[3]) && 
          (-1 == targetExecutionTime[4]) && 
          (-1 == targetExecutionTime[5]))
      {
         this.targetExecutionTime.setTime (jobEntryTime.getTime ());
      }
      else
      {
         GregorianCalendar tmpCal = 
            new GregorianCalendar ((targetExecutionTime[0] & 0xff) + 1900,   // year
                                   targetExecutionTime[1] - 1,      // month
                                   targetExecutionTime[2],          // day
                                   targetExecutionTime[3],          // hour
                                   targetExecutionTime[4],          // minute
                                   targetExecutionTime[5]);         // second
         this.targetExecutionTime = tmpCal.getTime ();
      }
   }

   public void setTargetExecutionTime (
         Date targetExecutionTime)
   {
      this.targetExecutionTime = targetExecutionTime;
   }

   public void setJobEntryTime (
         byte[] jobEntryTime)
   {
      if (jobEntryTime.length < 6)
      {
         // throw an exception
      }

      GregorianCalendar tmpCal = 
         new GregorianCalendar ((jobEntryTime[0] & 0xff) + 1900,    // year
                                jobEntryTime[1] - 1,       // month
                                jobEntryTime[2],           // day
                                jobEntryTime[3],           // hour
                                jobEntryTime[4],           // minute
                                jobEntryTime[5]);          // second
      this.jobEntryTime = tmpCal.getTime ();
   }

   public void setJobEntryTime (
         Date jobEntryTime)
   {
      this.jobEntryTime = jobEntryTime;
   }

   public void setJobNumber (
         int jobNumber)
   {
      this.jobNumber = jobNumber;
   }

   public void setJobType (
         int jobType)
   {
      this.jobType = jobType;
   }

   public void setJobPosition (
         int jobPosition)
   {
      this.jobPosition = jobPosition;
   }
    
   public void setJobControlFlags (
         int jobControlFlags)
   {
      this.jobControlFlags =  jobControlFlags;
   }

   public void setJobFileName (
         byte[] jobFileName)
   {
      int size = (jobFileName.length < this.jobFileName.length) ?
               jobFileName.length : this.jobFileName.length;
      System.arraycopy (
               jobFileName,
               0,
               this.jobFileName,
               0,
               size);
   }
   
   public void setJobFileHandle (
         int jobFileHandle)
   {
      this.jobFileHandle = jobFileHandle;
   }

   public void setServicingServerStation (
         int servicingServerStation)
   {
      this.servicingServerStation = servicingServerStation;
   }

   public void setServicingServerTask (
         int servicingServerTask)
   {
      this.servicingServerTask = servicingServerTask;
   }
   
   public void setServicingServerID (
         int servicingServerID)
   {
      this.servicingServerID = servicingServerID;
   }
       
   public void setJobDescription (
         String jobDescription)
   {
      if (jobDescription.length () > 50)
         this.jobDescription = jobDescription.substring (0, 50);
      else
         this.jobDescription = new String (jobDescription);
   } 

   public void setClientRecordArea (
         byte[] clientRecordArea)
   {
      int size = (clientRecordArea.length < this.clientRecordArea.length) ?
               clientRecordArea.length : this.clientRecordArea.length;
      System.arraycopy (
               clientRecordArea,
               0,
               this.clientRecordArea,
               0,
               size);
   } 

   // Get methods ============================================================
   public int getClientStation ()
   {
      return(this.clientStation);
   }

   public int getClientTask ()
   {
      return(this.clientTask);
   }

   public int getClientID ()
   {
      return(this.clientID);
   }

   public int getTargetServerID ()
   {
      return(this.targetServerID);
   }
    
   public byte[] getTargetExecutionTimeBytes ()
   {
      byte[] retArray = { -1, -1, -1, -1, -1, -1 };

      if (! targetExecutionTime.equals (jobEntryTime))
      {
         GregorianCalendar tmpCal = new GregorianCalendar ();

         tmpCal.setTime (targetExecutionTime);

         retArray[0] = (byte) (tmpCal.get (Calendar.YEAR) - 1900);
         retArray[1] = (byte) (tmpCal.get (Calendar.MONTH ) + 1);
         retArray[2] = (byte) tmpCal.get (Calendar.DATE);
         retArray[3] = (byte) tmpCal.get (Calendar.HOUR_OF_DAY);
         retArray[4] = (byte) tmpCal.get (Calendar.MINUTE);
         retArray[5] = (byte) tmpCal.get (Calendar.SECOND);
      }
      return (retArray);
   }

   public Date getTargetExecutionTime ()
   {
      return (new Date (targetExecutionTime.getTime ()));
   }

   public byte[] getJobEntryTimeBytes ()
   {
      byte[] retArray = { -1, -1, -1, -1, -1, -1 };
      GregorianCalendar tmpCal = new GregorianCalendar ();

      tmpCal.setTime (jobEntryTime);

      retArray[0] = (byte) (tmpCal.get (Calendar.YEAR) - 1900);
      retArray[1] = (byte) (tmpCal.get (Calendar.MONTH ) + 1);
      retArray[2] = (byte) tmpCal.get (Calendar.DATE);
      retArray[3] = (byte) tmpCal.get (Calendar.HOUR_OF_DAY);
      retArray[4] = (byte) tmpCal.get (Calendar.MINUTE);
      retArray[5] = (byte) tmpCal.get (Calendar.SECOND);

      return (retArray);
   }

   public Date getJobEntryTime ()
   {
      return (new Date (jobEntryTime.getTime ()));
   }

   public int getJobNumber ()
   {
      return (this.jobNumber);
   }

   public int getJobType ()
   {
      return (this.jobType);
   }

   public int getJobPosition ()
   {
      return (this.jobPosition);
   }
    
   public int getJobControlFlags ()
   {
      return (this.jobControlFlags);
   }

   public byte [] getJobFileName ()
   {
      byte[] retArray = new byte[this.jobFileName.length];
      System.arraycopy (this.jobFileName, 0, retArray, 0, retArray.length);
      return (retArray);
   }

   public int getJobFileHandle ()
   {
      return (this.jobFileHandle);
   }

   public int getServicingServerStation ()
   {
      return (this.servicingServerStation);
   }

   public int getServicingServerTask ()
   {
      return (this.servicingServerTask);
   }
   
   public int getServicingServerID ()
   {
      return (this.servicingServerID);
   }
       
   public String getJobDescription ()
   {
      return (new String (jobDescription));
   } 

   public byte [] getClientRecordArea ()
   {
      byte[] retArray = new byte[this.clientRecordArea.length];
      System.arraycopy (
               this.clientRecordArea,
               0,
               retArray,
               0,
               retArray.length);
      return (retArray);
   } 

} /* class NWQueueJob */

