/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/rfc1960/SSComponentEnumerator.java $
  $Revision: 2 $
  $Modtime: 4/08/98 11:21a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.rfc1960;

import java.util.*;

/**@Internal
 * RFC1960 (LDAP) Search String Component enumerator
 * 
 * <p>This object is returned by the Rfc1960Parsers getComponents 
 * method. </p>
 *
 */

public class SSComponentEnumerator
{
   private Vector components;
   private int index = 0;

   protected SSComponentEnumerator(Vector components)
   {
      this.components = components;   
   }

   public boolean hasMoreElements()
   {
      if (index < components.size())
         return true;

      return false;
   }

   public Object nextElement()
   {
      return next();
   }

   public SearchStringComponent next()
   {
      if (!hasMoreElements())
         throw new NoSuchElementException();

      return (SearchStringComponent) components.elementAt(index++);
   }
}

