/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/server/NWServer.java $
  $Revision: 7 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.server;

import java.util.Calendar;
import com.novell.service.jncp.NSIException;

/**
* Allows functions to be performed on the NetWare server that this
* NWServer represents.
* 
*/
public interface NWServer
{
  /**
   * Loads an NLM on the NetWare server.
   *
   * @param loadCommand The load command for the NLM:
   *                    {VOLUME NAME:}{PATH}NLMName{.ext}{parameters}
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void loadNLM(
         String loadCommand)
      throws NSIException;

  /**
   * Unloads an NLM from the NetWare server.
   *
   * @param name The name of the NLM (NLMName{.ext}) to be unloaded.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void unloadNLM(
         String name)
      throws NSIException;

  /**
   * Returns the time on the NetWare server.
   *
   * @return  The server's time as a Calendar object.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public Calendar getTime()
      throws NSIException;

  /**
   * Sets the time on the NetWare server.
   *
   * @param cal The Calendar time to set on the server.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setTime(
         Calendar cal)
      throws NSIException;
}
