/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/server/ServerCounts.java $
  $Revision: 9 $
  $Modtime: 1/28/00 12:46p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.server;

import com.novell.service.jncp.NSIException;

/**
 * Provides a specific attribute of a ServerDirContext. The ID of the
 * attribute is equal to ATTR_ID, and the attribute value is an object
 * that implements the ServerCounts interface.
 *
 * <p>The ServerCounts attribute does not support expanded search
 * capabilities, and thus, all fields must be set in a search request.
 */
public interface ServerCounts
{
  /**
   * The attribute ID of this attribute whose value is ServerCounts.
   *
   * <p>(ATTR_ID = "ServerCounts")
   */
   public final static String ATTR_ID = "ServerCounts";

   /**
   * @deprecated This member will be removed. Use ATTR_ID instead.
   */
   public final static String attrID = ATTR_ID;

  /**
   * Returns the number of the NCP requests since the server was
   * started.
   *
   * @return The number of NCP requests.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public int getNumberOfNCPRequests() throws NSIException;

  /**
   * Returns the maximum number of connection slots that the server
   * has allocated since it was started. It does not indicate how
   * many connections the server supports.
   *
   * @return  The maximum number of connection slots.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public short getMaxConnections() throws NSIException;

  /**
   * Returns the maximum number of licensed connections in use at
   * one time.
   *
   * @return  The maximum number of connections.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public short getMaxConnectionsUsed() throws NSIException;

  /**
   * Returns the number of connections currently in use.
   *
   * @return The number of connections in use.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public short getConnectionsInUse() throws NSIException;

  /**
   * Returns the maximum number of volumes supported.
   *
   * @return  The number of volumes supported.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public short getMaxVolumes() throws NSIException;

  /**
   * Returns the SFT level of the server.
   *
   * @return The server's SFT level.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public byte getSFTLevel() throws NSIException;

  /**
   * Returns the TTS level of the server.
   *
   * @return  The server's TTS level.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public byte getTTSLevel() throws NSIException;

  /**
   * Sets the number of NCP requests as the search value. This is
   * used to search for all servers matching the value parameter.
   *
   * @param value The number of NCP requests.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setNumberOfNCPRequests(
         int value)
      throws NSIException;
      
  /**
   * Sets the maximum number of connection slots as the search value.
   * This is used to search for all servers matching the value parameter.
   *
   * @param value The maximum number of connection slots.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setMaxConnections(
         short value)
      throws NSIException;
      
  /**
   * Sets the maximum number of licensed connections in use at
   * one time as the search value. This is used to search for
   * all servers matching the value parameter.
   *
   * @param value The maximum number of connections.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setMaxConnectionsUsed(
         short value)
      throws NSIException;
      
  /**
   * Sets the number of connections currently in use as the search
   * value. This is used to search for all servers matching the
   * value parameter.
   *
   * @param value The number of connections in use.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setConnectionsInUse(
         short value)
      throws NSIException;
      
  /**
   * Sets the maximum number of volumes supported as the search
   * value. This is used to search for all servers matching the
   * value parameter.
   *
   * @param value The number of volumes supported.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setMaxVolumes(
         short value)
      throws NSIException;
      
  /**
   * Sets the SFT level of the server as the search value. This is
   * used to search for all servers matching the value parameter.
   *
   * @param value The server's SFT level.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setSFTLevel(
         byte value)
      throws NSIException;
      
  /**
   * Sets the TTS level of the server as the search value. This is
   * used to search for all servers matching the value parameter.
   *
   * @param value The server's TTS level.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setTTSLevel(
         byte value)
      throws NSIException;
}
