/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/nds/NDSSessionState.java $
  $Revision: 23 $
  $Modtime: 8/06/01 10:13p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.nds;

import com.novell.service.jncpv2.clx.*;
import com.novell.service.session.*;
import com.novell.service.session.util.Debug;
import com.novell.service.session.xplat.*;
import com.novell.service.session.spi.*;
import com.novell.service.jncp.NSIException;
import com.novell.java.security.*;
import com.novell.service.security.NdsIdentity;
import com.novell.service.security.NdsIdentityScope;

/** @internal
 */
public abstract class NDSSessionState extends XplatSessionState
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
   final static private boolean DEBUG = false;
   final static private boolean I_DEBUG = false; // Ignore exception
   final static private boolean S_DEBUG = false; // May have side effects

   public NDSSessionState
   (
      SessionImpl attachedSession
   )
   throws SessionException
   {
      super(attachedSession);
   }

   /**
    * Inherited from Session
    *
    * @see Session#getAttributes()
    */
   public SessionAttrs getAttributes
   (
   )
   throws SessionException
   {
      try
      {
         // Get inherited attributes
         SessionAttrs attributes = super.getAttributes();

         // Override with this session's
         String attrIds[] =
         {
            Session.PROVIDER_NAME_ATTR_ID
         };
         attributes.modify(getStateAttrs(attrIds));

         return attributes;
      }
      catch (NSIException e)
      {
         throw InvalidSessionState.makeInvalid(this.attachedSession, e);
      }
   }

   /**
    * Inherited from Session
    *
    * @see Session#getAttributes(String[])
    */
   public SessionAttrs getAttributes
   (
      String attrIds[]
   )
   throws SessionException
   {
      try
      {
         // Get this session's attributes
         SessionAttrs attributes = new SessionAttrs();

         if (attributes.count() != attrIds.length)
         {
            // Get this state's attributes
            attributes.merge(getStateAttrs(attrIds));

            if (attributes.count() != attrIds.length)
            {
               // Get inherited attributes
               attributes.merge(super.getAttributes(attrIds));
            }
         }

         return attributes;
      }
      catch (NSIException e)
      {
         throw InvalidSessionState.makeInvalid(this.attachedSession, e);
      }
   }

   private SessionAttrs getStateAttrs
   (
      String attrIds[]
   )
   throws SessionException
   {
      // Get inherited attributes
      SessionAttrs attributes = new SessionAttrs();

      // Override with this session's
      for (int i = 0; i < attrIds.length; i++)
      {
         if (Session.PROVIDER_NAME_ATTR_ID.equals(attrIds[i]))
         {
            attributes.modify(
               Session.PROVIDER_NAME_ATTR_ID,
               NDS.PROVIDER_NAME);
         }
      }
      return attributes;
   }

   /**
    * Inherited from Session
    */
   public Session findSession(String domainName)
   throws SessionException
   {
      // Make sure existing code doesn't break...don't need padded
      // domain name any more
      return super.findSession(DomainName.stripUnderscores(domainName));
   }
}

