/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/xplat/NativeContext.java $
  $Revision: 9 $
  $Modtime: 8/26/99 2:11p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import com.novell.service.session.SessionException;
import com.novell.service.session.util.Debug;

/** @internal
 * Class which contains both a native context handle and a native thread group
 * id for use in nlm thread-group switching.
 *
 * Intended to be returned by ClxJNI.NWDSCreateContextHandle().
 */
abstract public class NativeContext
{
	final static private boolean   DEBUG = false;
	final static private boolean I_DEBUG = false;
	final static private boolean S_DEBUG = false; // May have side effects

   public int threadGroup = 0;  // Used by NLM platform only...currently
   public int contextHandle = -1;

   public NativeContext(
      int threadGroup,
      int contextHandle
   )
   {
      this.threadGroup = threadGroup;
      this.contextHandle = contextHandle;
   }

   abstract public void close();

   public void free()
   {
      try
      {
         Natives.freeNativeContext(
            this);
      }
      catch (SessionException e)
      {
         if (I_DEBUG)
         {
            Debug.ignoreException(e);
         }
      }
   }

   public String toString()
   {
      StringBuffer out = new StringBuffer();
      out.append("NativeContext$");
      out.append(
         ":C=0x" + Integer.toHexString(this.contextHandle));
      out.append(
         ":TG=0x" + Integer.toHexString(this.threadGroup));

      if (S_DEBUG)
      {

      }

      return (out.toString());
   }
}

