
/* **************************************************************************

  $Archive: /njcl/src/com/novell/utility/naming/spi/ContextFactoryBuilder.java $
  $Revision: 1 $
  $Modtime: 4/21/98 4:04p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.utility.naming.spi;


import javax.naming.NamingException;
import javax.naming.spi.ObjectFactoryBuilder;

import com.novell.utility.naming.Environment;


 /** @internal
  * The Novell framework allows for context implementations to
  * be loaded in dynamically via "context factories."  A ContextFactory is 
  * responsible for creating contexts of a specific type.  
  * A ContextFactoryBuilder contains the program-defined way of 
  * creating/loading context factories.  Any ContextFactoryBuilder 
  * implementation must implement this interface that for creating context 
  * factories.
  *
  * @see ObjectFactory
  */
public interface ContextFactoryBuilder extends ObjectFactoryBuilder
{
   /**
    * Creates a new context factory using the information supplied.
    *
    * @param object        The possibly null object for which to create 
    *                      a factory.
    * @param environment   Additional information to use when creating the 
    *                      factory.  Can be null.
    * @return     A new instance of an ObjectFactory. null if one cannot be 
    *             created.
    */
   public ContextFactory createContextFactory (
         Object object,
         Environment environment)
      throws NamingException;

} /* ContextFactoryBuilder */


