/***************************************************************************
 %name: DirectoryCreator.java
 %version: 
 %date_modified: 
 %dependencies: none

 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import javax.naming.directory.DirContext;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;

import com.novell.service.file.nw.DirectoryEntryInformation;
import com.novell.utility.naming.Environment;

/**
 * Creates a Directory subordinate to a specified DirectoryDirContext
 *
 * <p>This program demonstrates how to create a new directory subordinate to
 * an existing Directory DirContext which is specified on the command line.
 * The directory name being created can not already exist.
 * </p>
 *
 */

class DirectoryCreator
{
   /**
    * DirectoryCreator example
    *
    * <p>This example creates a directory in an existing Directory
    * DirContext in the NetWare file system name space.
    * </p>
    *
    * @param   args[]
    * where    args[0]  parent (parent path)
    *                   The name of a Directory DirContext to be the
    *                   parent for the newly created directory.
    *                   For example:
    *                   "my_server/my_volume/my_dir"
    *          args[1]  directory (new directory name to create)
    */

   public static void main(String args[])
   {
      // see if user has given the URL and directory on the command line
      if (args.length < 2)
      {
         help();
      }
      
      String parent = args[0];
      String directory = args[1];

      // Set the initial context factory to NetWareInitialContextFactory
      Hashtable systemProps = new Hashtable();
      systemProps.put(
         Context.INITIAL_CONTEXT_FACTORY,
         Environment.FS_INITIAL_CONTEXT_FACTORY);
      systemProps.put(Context.PROVIDER_URL, parent);

      try
      {
         // Look up the object named by the command line parameter.
         Object obj = new InitialContext(systemProps).lookup("");

         System.out.println("\nCreating " + directory + " in " + parent + "\n");

         // Cast the returned object to a DirContext
         DirContext currCtx = (DirContext) obj;

         /*
            Build an attribute set with the necessary information
            for createSubcontext(), which needs to know that the
            new subcontext will be a directory.
         */

         BasicAttributes attrSet = new BasicAttributes();
         BasicAttribute attr = new
            BasicAttribute(DirectoryEntryInformation.ATTRIBUTE_ID);

         // create the dei and set the directory bit in the attributes field
         DirectoryEntryInformation info =
            new DirectoryEntryInformation();

         info.setAttributes(DirectoryEntryInformation.A_DIRECTORY);

         // set the attribute value into the attribute
         attr.add(info);
         // set the attribute in the attribute set
         attrSet.put(attr);

         /*
            Create the directory. An exception will be thrown if
            the directory already exists.
         */
         currCtx.createSubcontext(directory, attrSet);
      }
      catch(javax.naming.NamingException e)
      {
         System.out.println("\nException thrown: " + e);
         e.printStackTrace();
         System.exit(-1);
      }
      System.exit(0);
   }

   private static void help()
   {
      System.out.println(
         "\nTo use this example program enter the following:\n");
      System.out.println(
         "\tjava DirectoryCreator <url> <directory>\n");
      System.out.println(
         "\t\turl = name of the directory to create the new directory in");
      System.out.println("\t\t       my_server/my_volume/my_dir");
      System.out.println(
         "\t\tdirectory  = new directory name to create");
      System.out.println("");
      System.exit(-1);
   }
}