/***************************************************************************
 %name: FileCreator.java
 %version: 
 %date_modified: 
 %dependencies: TextualDynamic.java TextualStatic.java
 
 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.novell.utility.naming.Environment;

import com.novell.java.io.DataAccessable;
import com.novell.java.io.NOutputStream;
import com.novell.java.io.NInputStream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.InputStream;

/**
 * Creates a File subordinate to a specified Directory DirContext
 *
 * <p>This program demonstrates how to create a new file subordinate to
 * an existing Directory DirContext which is specified on the command line.
 * The directory name being created can not already exist.  This is also an
 * example of how subordinate streams work.  See the Streams class for more
 * information on using streams and random access to file data.
 * </p>
 *
 * @see Streams
 */

class FileCreator
{
   /**
    * FileCreator example
    *
    * <p>This example creates a file in an existing Directory
    * DirContext in the NetWare file system name space.
    * </p>
    *
    * @param   args[]
    * where    args[0]  parent (parent path)
    *                   The name of a Directory DirContext to be the
    *                   parent for the newly created directory.
    *                   For example:
    *                   "my_server/my_volume/my_dir"
    *          args[1]  file (New file name to create)
    */

   public static void main(String args[])
   {
      // see if user has given the URL and file name on the command line
      if (args.length < 2)
      {
         help();
      }

      String parent = args[0];
      String file = args[1];
      StaticAttributeValueInterface sai = new TextualStatic(true);

      // Set the initial context factory to NetWareInitialContextFactory
      Hashtable systemProps = new Hashtable();
      systemProps.put(
         Context.INITIAL_CONTEXT_FACTORY,
         Environment.FS_INITIAL_CONTEXT_FACTORY);
      systemProps.put(Context.PROVIDER_URL, parent);

      // monitor open states so catch can close them if needed
      boolean osOpen = false;
      boolean isOpen = false;
      OutputStream os = null;
      InputStream is = null;

      try
      {
         // Look up the object named by the command line parameter.
         Object obj = new InitialContext(systemProps).lookup("");

         sai.message("\nCreating " + file + " in " + parent + "\n");

         /*
            if it's DataAccessable, use a subordinate output stream
            to create the file.
         */
         if (obj instanceof DataAccessable)
         {
            // open/create the file
            os = new NOutputStream(file, (DataAccessable) obj);
            osOpen = true;

            // write a well known pattern to the newly created file
            sai.writeStream(os);

            // clean up
            os.close();
            osOpen = false;

            // open the newly created file and verify contents
            is = new NInputStream(file, (DataAccessable) obj);
            isOpen = true;

            // read and verify well know pattern then close
            sai.readStream(is);
            is.close();
            isOpen = false;
         }else
         {
            System.out.println("error: " + parent + " is not DataAccessable");
            System.exit(-1);
         }
      }
      catch (IOException ioe)
      {
         try
         {
            if (osOpen)
               os.close();
            if (isOpen)
               is.close();
         } 
         catch (IOException nested)
         {
            System.out.println("error with close in catch: " + nested);
            nested.printStackTrace();
         }
         System.out.println("error with stream: " + ioe);
         ioe.printStackTrace();
         System.exit(-1);
      }
      catch(javax.naming.NamingException e)
      {
         System.out.println("\nException thrown: " + e);
         e.printStackTrace();
         System.exit(-1);
      }


      System.exit(0);
   }

   private static void help()
   {
      System.out.println(
         "\nTo use this example program enter the following:\n");
      System.out.println(
         "\tjava FileCreator <url> <file>\n");
      System.out.println(
         "\t\turl = name of the directory to create the new file in");
      System.out.println("\t\t       my_server/my_volume/my_dir");
      System.out.println(
         "\t\tfile  = new file name to create");
      System.out.println("");
      System.exit(-1);
   }
}

