/***************************************************************************
 %name: VolumeAttrList.java
 %version: 
 %date_modified: 
 %dependencies: TextualDynamic.java TextualStatic.java
 
 Copyright (c) 1998 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;

import javax.naming.directory.DirContext;

import com.novell.service.file.nw.NetwareVolume;
import com.novell.service.file.nw.NetwareDirectory;
import com.novell.service.file.nw.NetwareFile;
import com.novell.service.file.nw.DirectoryEntryInformation;
import com.novell.service.file.nw.TrusteeEnumerator;
import com.novell.service.file.nw.EAEnumerator;
import com.novell.service.file.nw.DirectorySpaceInformation;
import com.novell.service.file.nw.VolumeInformation;
import com.novell.service.file.nw.VolumeRestrictionEnumerator;
import com.novell.service.file.nw.VolumeUtilization;

import com.novell.utility.naming.Environment;

/**
 * Displays the attributes for a directory in the NetWare file system.
 *
 * <p>This program demonstrates using the Dynamic and Static attribute
 * interfaces of a directory DirContext in the NetWare file system.
 *
 * <p>The attribute values shown in the see list below are associated with a
 * directory and their use is outlined here:
 * </p>
 *
 * @see com.novell.service.file.nw.DirectoryEntryInformation
 * @see com.novell.service.file.nw.TrusteeEnumerator
 * @see com.novell.service.file.nw.EAEnumerator
 * @see com.novell.service.file.nw.DirectorySpaceInformation
 * @see com.novell.service.file.nw.VolumeInformation
 * @see com.novell.service.file.nw.VolumeRestrictionEnumerator
 * @see com.novell.service.file.nw.VolumeUtilization
 */

public class VolumeAttrList
{
   /**
    * VolumeAttrList example
    *
    * <p>This example lists the Attributes associated with a Volume
    * DirContext in the NetWare file system name space.
    * </p>
    *
    * <p>This program requires a command line parameter which specifies the
    * name of a VolumeDirContext in the file system name space 
    * whose attribute information is to be displayed.
    * </p>
    *
    * @param   args[]
    * where    args[0]  url (url of the volume to list)
    *          args[1]  objectName (objectName for VolumeUtilization)
    */

   public static void main(String args[])
   {
      // see if user has given the URL and objectName on the command line
      if (args.length < 2)
      {
         help();
      }

      String url = args[0];
      String objectName = args[1];
      StaticAttributeValueInterface sai = new TextualStatic(true);
      DynamicAttributeValueInterface dai = new TextualDynamic(true);

      // Set the initial context factory to NetWareInitialContextFactory
      Hashtable systemProps = new Hashtable();
      systemProps.put(
         Context.INITIAL_CONTEXT_FACTORY,
         Environment.FS_INITIAL_CONTEXT_FACTORY);
      systemProps.put(Context.PROVIDER_URL, url);

      try
      {
         // Look up the object named by the command line parameter.
         Object obj = new InitialContext(systemProps).lookup("");

         sai.message(
            "\nGetting attributes for Volume: " + url + "\n");

         /*
            First show the static interface to the attributes
         */

         sai.message(
            "\nStatic method, using the NetwareDirectory interface\n");

         if (!(obj instanceof NetwareVolume))
         {
            System.out.println(url + " does not specify a Volume");
            System.exit(-1);
         }

         // obtain and handle the Directory Entry Information
         sai.handleDirectoryEntryInformation((NetwareFile)obj);

         // obtain and handle the Trustees
         sai.handleTrusteeEnumerator((NetwareFile)obj);

         // obtain and handle the Extended Attributes
         sai.handleEAEnumerator((NetwareFile)obj);

         // obtain and handle the Directory Space Information
         sai.handleDirectorySpaceInformation((NetwareDirectory)obj);

         // obtain and handle the Volume Information
         sai.handleVolumeInformation((NetwareVolume)obj);

         // obtain and handle the Volume Restrictions
         sai.handleVolumeRestrictionEnumerator((NetwareVolume)obj);

         // obtain and handle the Volume Utilization
         sai.handleVolumeUtilization((NetwareVolume)obj, objectName);

         /*
            Now show the dynamic interface to the attributes
         */

         sai.message(
            "\nDynamic method, using the JNDI Attributes interface\n");

         // obtain and handle the Directory Entry Information
         dai.handleDirectoryEntryInformation(
            (DirectoryEntryInformation)
            dai.getAttribute(
                  DirectoryEntryInformation.ATTRIBUTE_ID,
                  (DirContext)obj),
            (DirContext)obj);

         // obtain and handle the Trustees
         dai.handleTrusteeEnumerator(
            (NamingEnumeration)
            dai.getAttribute(
                  TrusteeEnumerator.ATTRIBUTE_ID,
                  (DirContext)obj),
            (DirContext)obj);

         // obtain and handle the Extended Attributes
         dai.handleEAEnumerator(
            (NamingEnumeration)
            dai.getAttribute(
                  EAEnumerator.ATTRIBUTE_ID,
                  (DirContext)obj),
            (DirContext)obj);

         // obtain and handle the Directory Space Information
         dai.handleDirectorySpaceInformation(
            (DirectorySpaceInformation)
            dai.getAttribute(
                  DirectorySpaceInformation.ATTRIBUTE_ID,
                  (DirContext)obj),
            (DirContext)obj);

         // obtain and handle the Volume Information
         dai.handleVolumeInformation(
            (VolumeInformation)
            dai.getAttribute(
                  VolumeInformation.ATTRIBUTE_ID,
                  (DirContext)obj));

         // obtain and handle the Volume Restrictions
         dai.handleVolumeRestrictionEnumerator(
            (NamingEnumeration)
            dai.getAttribute(
                  VolumeRestrictionEnumerator.ATTRIBUTE_ID,
                  (DirContext)obj),
            (DirContext)obj);

         // obtain and handle the Volume Utilization
         dai.handleVolumeUtilization(
            (VolumeUtilization)
            dai.getAttribute(
                  VolumeUtilization.ATTRIBUTE_ID,
                  (DirContext)obj),
            objectName);
      }
      catch (javax.naming.NamingException e)
      {
         System.out.println("Exception thrown: " + e);
         e.printStackTrace();
         System.exit(-1);
      }
      System.exit(0);
   }

   private static void help()
   {
      System.out.println(
         "\nTo use this example program enter the following:\n");
      System.out.println(
         "\tjava VolumeAttrList <url> <objectName>\n");
      System.out.println(
         "\t\turl = name of the Volume to which to list attributes");
      System.out.println("\t\t       my_server/my_volume");
      System.out.println(
         "\t\tobjectName  = name to which to obtain VolumeUtilization information");
      System.out.println("\t\t       admin+1");
      System.out.println("");
      System.exit(-1);
   }
}

