/****************************************************************************
  $Archive: /njcl_sample/NJCLApplet/src/RenameFrame.java $
  $Revision: 1 $
  $Modtime: 3/18/99 3:29p $

  Copyright (c) 1999 Novell, Inc.  All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
 ***************************************************************************/

import java.util.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * This class provides a graphical input dialog for renaming a context.
 */

public class RenameFrame
   extends JDialog
   implements ActionListener
{
   private static int buttonHeight = 25;
   private static int buttonWidth = 100;
   private static int mainPaneHeight = 100;
   private static int mainPaneWidth = 400;

   // Declare controls
   JButton     okButton;
   JButton     cancelButton;
   JLabel      oldNameLabel;
   JLabel      newNameLabel;
   JTextField  oldNameTextField;
   JTextField  newNameTextField;

   String newNameText;         // May be null or empty

   /**
    * Constructs the GUI portion of the rename frame.
    */
   public RenameFrame (
         JFrame frame,
         String oldName)
   {
      super (frame, "Rename", true);
      GridBagLayout gbLayout = new GridBagLayout ();
      getContentPane ().setLayout (gbLayout);
      setSize (mainPaneWidth, mainPaneHeight);
      
      // Old name label and field
      oldNameLabel = new JLabel ("OLD name");
      oldNameLabel.setSize (buttonWidth, buttonHeight);
      Util.addGridBagComponent (getContentPane (), oldNameLabel, 0, 0, 1, 1, 0.0, 0.0);
      oldNameTextField = new JTextField (oldName);
      oldNameTextField.setEditable (false);
      oldNameTextField.setSize (mainPaneWidth - buttonWidth, buttonHeight);
      Util.addGridBagComponent (getContentPane (), oldNameTextField, 1, 0, 1, 1, 0.0, 0.0);

      // New name label and field
      newNameLabel = new JLabel ("NEW name");
      newNameLabel.setSize (buttonWidth, buttonHeight);
      Util.addGridBagComponent (getContentPane (), newNameLabel, 0, 1, 1, 1, 0.0, 0.0);
      newNameTextField = new JTextField ();
      newNameTextField.setSize (mainPaneWidth - buttonWidth, buttonHeight);
      Util.addGridBagComponent (getContentPane (), newNameTextField, 1, 1, 1, 1, 0.0, 0.0);

      // Buttons
      JPanel buttonPanel = new JPanel (new FlowLayout (FlowLayout.CENTER));
      okButton = new JButton ("OK");
      okButton.setToolTipText ("Rename the object");
      okButton.setSize (buttonWidth, buttonHeight);
      okButton.addActionListener (this);
      buttonPanel.add (okButton);
      
      cancelButton  = new JButton ("Cancel");
      cancelButton.setToolTipText ("Cancel the rename operation");
      cancelButton.addActionListener (this);
      cancelButton.setSize (buttonWidth, buttonHeight);
      buttonPanel.add (cancelButton);
      Util.addGridBagComponent (getContentPane (), buttonPanel, 0, 2, 2, 1, 0.5, 0.0);
      
      addWindowListener (new RenameWindowAdapter ());
   } // RenameFrame ()

   /**
    * Inner class for handling focus change and window close events.
    */
   class RenameWindowAdapter
      extends WindowAdapter
   {
      private boolean firstTime = true;
      
      public void windowActivated (WindowEvent event)
      {
         if (firstTime)
         {
            newNameTextField.requestFocus ();
            firstTime = false;
         }
      }

      public void windowClosing (WindowEvent event)
      {
         newNameText = null;
         setVisible (false);
      }
   } // class RenameWindowAdapter

   /**
    * ActionListener event handler method.
    */
   public void actionPerformed (
         ActionEvent event)
   {
      Object object = event.getSource ();
      if (object == okButton)
      {
         newNameText = newNameTextField.getText ();
         if (newNameText.equals (""))
            newNameText = null;
         setVisible (false);
      }
      else if (object == cancelButton)
      {
         newNameText = null;
         setVisible (false);
      }
   } // ActionListener.actionPerformed ()

   /**
    * Return the text entered (or NULL if none or cancel).
    *
    * @return                    The new name string entered. May be NULL.
    */
   public String getText ()
   {
      return (newNameText);
   } // getText ()
   
} // class RenameFrame

