/****************************************************************************
  $Workfile: NSIBrowser.java $
  $Revision: 1 $
  $Modtime:: $
  $Copyright:

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.$

 ***************************************************************************/

import java.awt.*;
import java.applet.Applet;
import java.util.*;
import java.io.*;

/**
 * This is the main class for the NSI Browser (GUI) application.
 *
 * This class contains the main method and is responsible for constructing
 * and starting up the browser frame.
 */

public class NSIBrowser extends Applet
{
   // Configuration file information and property names
   public static final String cfgFileName = "NSIBrowser.ini";
   public static final String jndiInitCtxProp = "java.naming.factory.initial";
   public static final String jndiHostProp = "java.naming.provider.url";
   static String listClassesProp = "nsi.Browser.listClasses";
   static String listBindingsProp = "nsi.Browser.listBindings";
//   static String snapInProp = "nsi.Browser.specialBinding";

   static NSIBrowserFrame mainFrame = null;

   /**
    * This is the starting method used for the stand alone NSIBrowser app.
    *
    * @param     args            (in) The command line arguments
    */
   public static void main
   (
      String[] args
   )
   {
      NSIBrowser browser = new NSIBrowser ();
      browser.init ();
   }

   /**
    * The init() method is a required part of an applet and is responsible
    * for constructing and displaying the program's window (frame).
    */
   public void init ()
   {
      mainFrame = new NSIBrowserFrame (
            "NSI Browser Demo",
            null,
            null);
      mainFrame.setSize (NSIBrowserFrame.width, NSIBrowserFrame.height);
      mainFrame.show ();

      // Check for a configuration file and use it if it exists
      readConfigFile ();
      mainFrame.setProperties (System.getProperties ());

      // Get the name list (possibly empty)
      mainFrame.resetInitCtx ();
   } // init ()

   /**
    * Reads in the NSI browser configuration file and updates the system
    * properties with any changes needed.
    */
   void readConfigFile ()
   {
      // Check for a configuration file and use it if it exists
      // Note: this adds only previously undefined properties
      File cfgFile = new File (cfgFileName);
      try
      {
         if (cfgFile.exists ())
         {
            if (cfgFile.isFile () && cfgFile.canRead ())
            {  // We have a configuration file so read it and use it
               FileInputStream inFile = new FileInputStream (cfgFile);
               Properties newProps = new Properties ();
               newProps.load (inFile); // Read properties from the file

               // Now merge the configuration file with the system properties
               Properties sysProps = System.getProperties ();
               boolean propChange = false;   // Set to true of change needed
               Enumeration nameEnum = newProps.propertyNames ();
               while (nameEnum.hasMoreElements ())
               {
                  String propName = (String) nameEnum.nextElement ();
                  if (false == sysProps.containsKey (propName))
                  {  // This isn't in the system properties yet so add it
                     propChange = true;
                     sysProps.put (propName, newProps.getProperty (propName));
                  }
               }
               if (propChange)
               {
                  System.setProperties (sysProps);
               }
            }
         } // if (file.exists ())
      } // try
      catch (Exception e)
      {
         System.out.println ("Unexpected configuration file exception : " + e);
         e.printStackTrace ();
      }

      // See if the initial context property is set
      String initPropVal = System.getProperty (jndiInitCtxProp);
      if ((null == initPropVal) || (initPropVal.equals ("")))
      {  // We have no initial context so TRY to get one (not required)
         Frame f = new NSIInitialContextFrame (mainFrame);
         f.show ();
      }
      String propVal;

      propVal = System.getProperty (listClassesProp);
      if ((null != propVal) && (propVal.equalsIgnoreCase ("true")))
         mainFrame.doListClasses = true;
      propVal = System.getProperty (listBindingsProp);
      if ((null != propVal) && (propVal.equalsIgnoreCase ("true")))
         mainFrame.doListBindings = true;

   } // readConfigFile ()

   /**
    * Saves the configuration information to the configuration file.
    */
   public static void saveConfigFile ()
   {
      Properties myProps = new Properties ();
      String propVal;

      // Read in the current stuff so we preserve extra settings
      try
      {
         FileInputStream in = new FileInputStream (
                                       NSIBrowser.cfgFileName);
         myProps.load (in);
      }
      catch (FileNotFoundException e)
      {  // We don't need to do anything, we can just ignore the exception
      }
      catch (IOException e)
      {
         System.out.println (
            "Unable to read configuration file:" + cfgFileName);
         System.out.println ("Unexpected IO exception : " + e);
         e.printStackTrace ();
      }
      if (null != (propVal = System.getProperty (jndiInitCtxProp)))
         myProps.put (jndiInitCtxProp, propVal);
      if (null != (propVal = System.getProperty ("nsi.domainName")))
         myProps.put ("nsi.domainName", propVal);
      if (null != (propVal = System.getProperty (jndiHostProp)))
         myProps.put ("java.naming.provider.url", propVal);
      myProps.put (
               listClassesProp,
               (mainFrame.doListClasses) ? "true" : "false");
      myProps.put (
               listBindingsProp,
               (mainFrame.doListBindings) ? "true" : "false");
      try
      {  // Save the system properties in the configuration file
         myProps.save (
               new FileOutputStream (cfgFileName),
               "NSI Browser System Properties");
      }
      catch (IOException e)
      {
         System.out.println (
            "Unable to save configuration file :" + cfgFileName);
         System.out.println ("Unexpected IO exception : " + e);
         e.printStackTrace ();
      }

   } // saveConfigFile ()

} // class NSIBrowser
