/****************************************************************************
  $Workfile: NSIInitialContextFrame.java $
  $Revision: 1 $
  $Modtime:: $
  $Copyright:

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.$

 ***************************************************************************/

import java.awt.*;
import java.awt.event.*;
import java.util.Properties;

/**
 * This class handles the setting of the initial context parameter for JNDI.
 */

public class NSIInitialContextFrame extends Frame
                                    implements WindowListener,
                                    ActionListener
{
   public static final int width = 350;
   public static final int height = 75;

   TextField initCtxField;
   Button okButton = new Button ("Apply");
   Button cancelButton = new Button ("Cancel");
   String jndiInitCtxProp = "java.naming.factory.initial";
   NSIBrowserFrame parent;

   /**
    * Constructor for the initial context frame.
    *
    * @param     parent          (in) The parent frame
    */
   public NSIInitialContextFrame
   (
      NSIBrowserFrame parent
   )
   {
      super ("Initial Context Implementation");
      this.parent = parent;      // Save the parent

      NSIForm f = new NSIForm (this);

      // Set up the entry for the user with the current value
      initCtxField = f.addRow ("Class name:");
      String initPropVal = System.getProperty (jndiInitCtxProp);
      if (null != initPropVal)
         initCtxField.setText (initPropVal);

      // Setup the ok and cancel buttons
      Panel p = new Panel ();
      p.setLayout (new GridLayout (1, 0));
      p.add (okButton);
      p.add (cancelButton);
      f.addRow (p);

      // Setup the Listeners
      addWindowListener (this);
      okButton.addActionListener (this);
      cancelButton.addActionListener (this);
   }

   /**
    * This is the action handler for the initial context window (frame).
    *
    * @param     evt             (in) The event
    */
   public void actionPerformed (
      ActionEvent evt)
   {
      Object target = evt.getSource();
      // Handle the button actions
      if (target == okButton)
      {
         String classname = initCtxField.getText ();
         // Adjust the system properties field to include the new value
         Properties props = System.getProperties ();

         if (classname == null || (true == classname.equals ("")))
         {  // Clear the initial context property
            props.remove (jndiInitCtxProp);
         }
         else
         {  // Set the initial context property
            props.put (jndiInitCtxProp, classname);
            System.setProperties (props);
         }

         // Reflect any possible changes to the initial context
         parent.resetInitCtx ();    // Update the initial context

         // Close the window and return to the main window (frame).
         dispose();
      }
      else if (target == cancelButton)
      {
         // Close the window and return to the main window (frame).
         dispose();
      }
   }

   /**
    * Implement WindowListener functions.  We really only want the
    * windowClosing one.
    */

   public void windowClosed (
      WindowEvent event)
   {
   }

   public void windowDeiconified (
      WindowEvent event)
   {
   }

   public void windowIconified (
      WindowEvent event)
   {
   }

   public void windowActivated (
      WindowEvent event)
   {
   }

   public void windowDeactivated (
      WindowEvent event)
   {
   }

   public void windowOpened (
      WindowEvent event)
   {
   }

   public void windowClosing (
      WindowEvent event)
   {
      dispose ();
   }

}
