/* **************************************************************************

  $Archive: /njcl/src/com/novell/java/security/AuthenticatorChannel.java $
  $Revision: 5 $
  $Modtime: 5/21/98 8:21p $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.java.security;

import java.io.*;

/**@internal
 *
 * This interface represents the communication channel between two 
 * authentication points.  Authentication requestors and responders which
 * implement this interface can be managed by the <code>Authenticator</code>.
 *
 *
 * @author  Jan Sture Nielsen
 * @version 1.0.0 97/11/01
 *
 * @see Authenticator
 * @see AuthenticatorProtocol
 */
public interface AuthenticatorChannel extends java.lang.Runnable
{
   /**
    * configure the channel from the subset of the <code>properties</code> 
    * which start with the <code>baseKey</code>
    *
    * @param properties list of properties from which to extract 
    * configuration information
    * @param baseKey base key from which to extract info the configuration
    * information relevant to the channel
    *
    * @exception ConfigurationException configuration error occurred
    *
    * @see #init
    */
   void configure(java.util.Properties properties, String baseKey)
		throws ConfigurationException;

   /**
    * initialize the authentication protocol for the authentication channel
    *
    * @param protocols authentication protocols to be used in the channel
    *
    * @exception InvalidAuthenticatorProtocolException protocol not 
    * supported by channel
    *
    * @see #configure
    */
   void init(AuthenticatorProtocol protocols[]) 
      throws InvalidAuthenticatorProtocolException;

   /**
    * get the loaded protocols
    *
    * @return <code>AuthenticationProtocol []</code> array of loaded protocols
    *
    * @exception InvalidAuthenticatorProtocolException protocol is 
    * not supported by channel
    */
   AuthenticatorProtocol[] getProtocols();
   
   /**
    * call-back to the channel which indicates the beginning of an 
    * authentication protocol
    *
    * @param protocol authentication protocol which is signaling beginning
    *
    * @exception AuthenticatorChannelException error in the authentication channel
    *
    * @see #endProtocol
    */
   void beginProtocol(AuthenticatorProtocol protocol) 
      throws AuthenticatorChannelException;

   /**
    * read from the channel placing the result in the supplied buffer
    *
    * @param read buffer being filled up to <code>read.length</code> bytes
    *
    * @return number of bytes read
    *
    * @exception AuthenticatorChannelException thrown if the read fails
    *
    * @see #write
    * @see #writeRead
    */
   int read(byte read[]) 
      throws AuthenticatorChannelException;

   /**
    * read from the channel placing the result in the supplied buffer
    *
    * @param read buffer being filled up to <code>read.length</code> bytes
    * @param offset buffer offset to start at in read operation
    * @param length maximum number of byte to write
    *
    * @return number of bytes read
    *
    * @exception AuthenticatorChannelException thrown if the read fails
    *
    * @see #write
    * @see #writeRead
    */
   int read(byte read[], int offset, int length) 
      throws AuthenticatorChannelException;

   /**
    * write the buffer followed by a read placing result in the supplied buffer
    *
    * @param write buffer being sent
    * @param read buffer being filled up to <code>read.length</code> bytes
    *
    * @return int number of bytes read
    *
    * @exception AuthenticatorChannelException error reading or writing to channel
    *
    * @see #read
    * @see #write
    */
   int writeRead(byte write[], byte read[]) 
      throws AuthenticatorChannelException;

   /**
    * write the buffer
    *
    * @param write buffer being sent
    *
    * @exception AuthenticatorChannelException error writing to channel
    *
    * @see #read
    * @see #writeRead
    */
    void write(byte write[]) 
       throws AuthenticatorChannelException;

   /**
    * call-back to the channel which indicates the completion of 
    * an authentication protocol and passes the resultant credential
    * to the authentication channel
    *
    * @param protocol authentication protocol which is 
    * signaling completion
    *
    * @exception AuthenticatorChannelException error in the 
    * authentication channel
    *
    * @see #beginProtocol
    */
   void endProtocol(AuthenticatorProtocol protocol)
      throws AuthenticatorChannelException;
}
