/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/java/util/UnhandledRuntimeException.java $
  $Revision: 1 $
  $Modtime: 4/06/00 6:02p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.java.util;

import com.novell.service.jncpv2.clx.*;
import java.lang.RuntimeException;
import com.novell.java.lang.HasRootCause;

/**
 * Provides an exceptions for cases that are considered catastrophic.
 * In such cases there is no chance of application recovery. This does
 * not preclude application attempts at recovery, however keep in mind
 * that these attempts may become implementation-specific, and thus might
 * become obsolete against future releases of this class library.
 */
public class UnhandledRuntimeException
extends RuntimeException
implements java.io.Serializable, HasRootCause
{
  /**
   * @internal
   */
   protected Throwable rootException = null;

   /**
    * Constructs a UnhandledRuntimeException with the specified detail message.
    * A detail message is a String that describes this particular exception.
    *
    * @param s The detail message describing this exception.
    */
   public UnhandledRuntimeException
   (
      String s
   )
   {
      super(s);
   }

   /**
    * Constructs a UnhandledRuntimeException with a detail message and a
    * root-cause exception. The root cause exception can be retrieved
    * using the getRootCause() method.
    *
    * @param s The detail message describing the exception.
    * @param rootException The root-cause exception.
    */
   public UnhandledRuntimeException
   (
      String s,
      Throwable rootException
   )
   {
      super(s);
      this.rootException = rootException;
   }

   /**
    * Returns the root-cause exception. It is inherited from
    * HasRootCauses().
    *
    * @return The root cause exception as a Throwable object.
    */
   public Throwable getRootCause
   (
   )
   {
      return rootException;
   }

   /**
    * Returns a short description of this throwable object.
    *
    * @return A string representation of this root-cause exception.
    */
   public String toString()
   {
      String s = super.toString();
      if (null != rootException)
         s += "; check root cause";
      return s;
   }
}


