/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/bindery/ServerBinderyObjectDirContext.java $
  $Revision: 9 $
  $Modtime: 8/11/99 10:25a $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.bindery;

import java.util.*;
import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.spi.*;
import  com.sun.jndi.toolkit.ctx.*;

import com.novell.service.session.*;
import com.novell.java.lang.*;
import com.novell.utility.naming.Environment;

/**
 * Represents a bindery object that is a server.
 * ServerBinderyObjectDirContext is responsible for federating
 * from the bindery name system to the server name system.
 * As such, it subclasses BinderyObjectDirContext and obtains
 * all of its other functionality from that parent class.
 *
 * @see BinderyObjectDirContext
 */

public class ServerBinderyObjectDirContext
   extends BinderyObjectDirContext
{

   /**@internal
    * The constructor does nothing more than call super().  The only thing
    * unique about this class is the federation point, and that does not
    * require anything special to be done in the constructor.
    */
   public ServerBinderyObjectDirContext (
         Environment    env,
         String         binderyObjectName,
         int            binderyObjectType,
         int            binderyObjectID,
         int            hasProperties,
         int            objSecurity,
         int            objFlags)
      throws NamingException
   {
      super (
         env,
         binderyObjectName,
         binderyObjectType,
         binderyObjectID,
         hasProperties,
         objSecurity,
         objFlags    );
   } // ServerBinderyObjectDirContext ()

   // Since this is a Federation point, need to implement nns methods.

   /**@internal
    */
   protected Object a_resolveIntermediate_nns (
         String name,
         Continuation cont)
      throws NamingException
   {
      return a_lookup_nns (name, cont);
   } // a_resolveIntermediate_nns ()

   /**@internal
    */
   public Object a_lookup_nns (
         String name,
         Continuation cont)
      throws NamingException
   {
      Object    nnsp = null;
      Reference ref  = null;

      if (isEmpty(name))
      {  // Name is empty, user did lookup("/...")
         try
         {
            Hashtable hash = new Hashtable ();
            hash.put (PROVIDER_URL, binderyObjectNameOnly);

            com.novell.service.server.ReferenceFactoryImpl referenceFactory =
               new com.novell.service.server.ReferenceFactoryImpl ();

            ref = referenceFactory.createReference (hash);
            nnsp = NamingManager.getObjectInstance (ref, null, null, getEnvironment());
         }
         catch (NamingException e)
         {
            cont.setError (this, name);
            throw cont.fillInException (e);
         }
         catch (Exception e)
         {
            NamingException ne = new NamingException ();
            cont.setError (this, name);
            ne.setRootCause (e);
            throw cont.fillInException (ne);
         }

         if (nnsp != null)
         {
            cont.setSuccess ();
            return nnsp;
         }
         else
         {
            cont.setErrorNNS (this, name);
            NameNotFoundException e = new NameNotFoundException ();
            throw cont.fillInException (e);
         }
      }
      else
      {  // no objects to lookup since we are a flat namespace
         cont.setError (this, name);
         NameNotFoundException e = new NameNotFoundException();
         throw cont.fillInException(e);
      }
   } // a_lookup_nns ()

} // class ServerBinderyObjectDirContext

