/*
 * Copyright (c) 1993-1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * The Java source code is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You shall
 * not disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.

 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
/*
 * @(#)mutex_md.h	1.8 95/11/18
 *
 */

/*-
 * Machine dependent mutex definitions.  For NetWare we use local
 * semaphores to implement interpreter mutexes.
 *
 * It's worth noting that the NetWare functions supporting critical
 * sections do not provide any error information whatsoever (i.e.
 * all critical section routines return (void)).
 */

#ifndef	_NW_MUTEX_MD_H_
#define	_NW_MUTEX_MD_H_

#include <nwsemaph.h>

#include "sys_api.h"

#define LinkInSemaphore( sem )                        \
   if (sem->signature == SEMAPHORE_SIGNATURE) {       \
      if (sem->count != 0) {                          \
         Breakpoint((LONG)"Sem being reused, count !=0");   \
         sem->count = 0;                              \
         }                                            \
      sem->tidOwner = (sys_thread_t *)-1;             \
      return SYS_OK;                                  \
      }                                               \
   sem->count = 0;                                    \
   sem->tidOwner = (sys_thread_t *)-1;                \
   sem->tidCreator = sysThreadSelf();                 \
   sem->signature = SEMAPHORE_SIGNATURE;              \
   link( hdSemTracking, ((semaphore_t *)sem) );

#define UnlinkSemaphore( sem )                        \
   sem->signature = 'gone';                           \
   delink( sem );

#define SEMAPHORE_SIGNATURE 'JSEM'

typedef struct S_semaphore {
   struct S_semaphore   *lnkForward;
   struct S_semaphore   *lnkBackward;
   LONG                  signature;
   LONG                  hSemaphore;
   LONG                  count;
   sys_thread_t         *tidOwner;
   sys_thread_t         *tidCreator;
	void						*next;
} semaphore_t;

typedef struct {
#ifdef	WATCOM
   semaphore_t;
#else
	/* above not supported -- JKM */
   struct S_semaphore   *lnkForward;
   struct S_semaphore   *lnkBackward;
   LONG                  signature;
   LONG                  hSemaphore;
   LONG                  count;
   sys_thread_t         *tidOwner;
   sys_thread_t         *tidCreator;
#endif
   } mutex_t;

int	mutexInit(mutex_t *);
void	mutexDestroy(mutex_t *);
void	mutexLock(mutex_t *);
void	mutexUnlock(mutex_t *);

extern semaphore_t hdGlobalSemTracking;

#endif	/* !_NW_MUTEX_MD_H_ */
