/*
 * Copyright (c) 1993-1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * The Java source code is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You shall
 * not disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.

 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
/*
 * @(#)threads_md.h	1.16 95/11/20
 *
 */

/*
 * NetWare dependent threads API
 */

#ifndef _NW_THREADS_MD_H_
#define _NW_THREADS_MD_H_

#include <nwthread.h>
#include "bool.h"

#define N_TRACED_REGS 7				/* for java11 -- from 0 to 7 -- JKM */

#define SYS_THREAD_NULL				((sys_thread_t *) 0)

#define FPU_BUFFER_SIZE				28	// >108 bytes
#define JAVA_REGISTER_BUFFER_SIZE	(14+FPU_BUFFER_SIZE)

typedef enum {
    RUNNABLE,
    SUSPENDED,
    SLEEPING,
    MONITOR_WAIT,
    CONDVAR_WAIT,
    CLEANING_UP
} thread_state_t;

/*
 * Machine dependent thread data structure (includes active list/queue stuff)
 */
typedef struct sys_thread {
    void   *cookie;                 /* back pointer to shared thread_t */

	int    nw_thread_id;
	int    parent_nw_thread_id;
	int    priority;
	int    exceptionFlag;
	LONG   activeTime;	            /* time (ticks) threads been running */
                                    /* buffer for preempted registers */
	LONG   regBuf[JAVA_REGISTER_BUFFER_SIZE];
	LONG   addressSpace;
	struct sys_thread *semList;
	LONG   blockedOnMutex;
	LONG   condvarWait;
	LONG   this;
	LONG   stack_size;              /* Thread stack size */

	void   *stack_base;             /* Thread stack base */
	void   *(*start_proc)(void *);  /* Thread start routine address */
	void   *start_parm;             /* Thread start routine parameter */
	struct sys_thread *next;        /* Next thread in active thread queue */
	thread_state_t state;           /* Current thread state */

	bool_t system_thread;           /* TRUE if this is a system thread */
	bool_t interrupt_event;			/*  */
	bool_t interrupted;				/*  */
	bool_t preemptable;				/* TRUE if thread is preemptable */
} sys_thread_t;

extern bool_t ThreadsInitialized;

int sysInitializeRuntime( void );

void logmsg( char *format, ... );

#endif /* !_NW_THREADS_MD_H_ */
