
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/jncpv2/net/BasicNetGetServerDNService.java $
  $Revision: 6 $
  $Modtime: 1/28/00 11:48a $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.jncpv2.net;


import com.novell.service.jncp.NSIExceptionBuilder;

import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.Connection;
import com.novell.service.session.xplat.NDSContext;


/** @internal
 * Object returned by Session.getService() that wraps all NWNET
 * native services (via NetJNI).
 */
public class BasicNetGetServerDNService extends NetGetServerDNService
{
   protected static final String KEY = NetGetServerDNService.KEY;


   protected NDSContext context;
   protected int hdlContext;
   protected Connection connection;
   protected int hdlConnection;

   protected int threadGroup;

   /**
    *
    */
   public BasicNetGetServerDNService (
         NDSContext context)
      throws SessionException
   {
      this.context = context;
      hdlContext = context.getHandle ();
      this.connection = context.getConnection ();
      hdlConnection = connection.getHandle ();

      threadGroup = context.getNativeHandle().threadGroup;
   }


   // ******************* NetGetServerDNService Interface *******************

   /**
    *
    */
   public final String getServerDN ()
      throws SessionException
   {
      int ccode;
      StringBuffer serverDN = new StringBuffer (NetService.MAX_DN_CHARS + 1);

      ccode = NetJNI.NWDSGetServerDN (
                        threadGroup,
                        this.hdlContext,
                        this.hdlConnection,
                        serverDN);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return (new String (serverDN));

   } /* getServerDN () */

} /* BasicNetGetServerDNService */


