/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/jncpv2/net/NetAttributeInfo.java $
  $Revision: 5 $
  $Modtime: 1/28/00 12:45p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.jncpv2.net;

import java.io.Serializable;
import com.novell.service.jncp.NSIException;

/** @internal
 *
 */
public final class NetAttributeInfo implements Serializable
{
   //* **********************************************************************
   // Private Instance Variables
   //************************************************************************

   private int          flags;
   private int          syntaxID;
   private int          lower;
   private int          upper;
   private NetAsn1ID    asn1ID;

   //* **********************************************************************
   // Protected Constructors
   //************************************************************************


   /**
    * xxx.
    * </p>
    */
   public NetAttributeInfo ()
   {
      this.asn1ID = new NetAsn1ID ();

   } /* NetAttributeInfo () */


   /**
    * xxx.
    * </p>
    *
    * @param   <i>flags</i>  (in) xxx.
    * @param   <i>syntaxID</i>
    *                            (in) xxx.
    * @param   <i>lowerLimit</i>  (in) xxx.
    * @param   <i>upperLimit</i>  (in) xxx.
    * @param   <i>asn1ID</i>  (in) xxx.
    *
    * @return                    xxx.
    */
   public NetAttributeInfo (
         int   flags,
         int   syntaxID,
         int   lowerLimit,
         int   upperLimit,
         NetAsn1ID asn1ID)
   {
      this.flags =      flags;
      this.syntaxID =   syntaxID;
      this.lower =      lowerLimit;
      this.upper =      upperLimit;
      this.asn1ID = asn1ID;

   } /* NetAttributeInfo () */

   //* **********************************************************************
   // Public Instance Methods
   //************************************************************************

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   public int getFlags ()
   {
      return flags;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   public int getSyntaxID ()
   {
      return syntaxID;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   public int getLowerLimit ()
   {
      return lower;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   public int getUpperLimit ()
   {
      return upper;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    *
    * @exception  NSIException   xxx.
    */
   public NetAsn1ID getAsn1ID ()
   {
      return asn1ID; // NOTE: clone this
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   protected void setFlags (
         int flags)
   {
       this.flags = flags;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   protected void setSyntaxID (
         int syntaxID)
   {
      this.syntaxID = syntaxID;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   protected void setLowerLimit (
         int lowerLimit)
   {
      this.lower = lowerLimit;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   protected void setUpperLimit (
         int upperLimit)
   {
      this.upper = upperLimit;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    *
    * @exception  NSIException   xxx.
    */
   protected void setAsn1IDData(byte [] data)
      throws NSIException
   {
      asn1ID.setData(data);
   }

} /* NetAttributeInfo */


