/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/ncpext/NCPExtension.java $
  $Revision: 11 $
  $Modtime: 1/28/00 12:45p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.ncpext;

import com.novell.service.jncp.NSIException;

/**
 * Represents an NCP Extension registered on the NetWare server.
 * 
 * <p>An NPCExtension allows you to send requests to and receive replies
 * from NCP Extensions registered on a NetWare Server. It has one single-
 * valued attribute with the attribute ID equal to NCPExtensionInfo.
 *
 * @see NCPExtensionInfo
 */
public interface NCPExtension
{
  /**
   * Sends a request to an NCP Extension. Request data for the NCP
   * Extension must be packed into the request byte array. Any return
   * data will be contained in the return byte array.
   *
   * <p>A temporary buffer set to the size specified by the maxReplyLength
   * parameter will be allocated. For performance reasons, specify as small
   * an amount as you will need. The actual amount returned will be less
   * than or equal to this number, which must be <= 0xFFFF, because it is
   * treated as an unsigned short.
   *
   * @param request        The byte array containing request data.
	* @param maxReplyLength The maximum number of bytes the user wants
   *                       returned.
   *
   * @return    A byte array containing reply data.
   *
   * @exception NSIException Standard NJCL exception for working on top
   *                         of Xplat libraries.
   */
   public byte[] send(
         byte[] request,
         int maxReplyLength)
      throws NSIException;
}
