
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nds/naming/Partitionable.java $
  $Revision: 4 $
  $Modtime: 2/02/00 9:41a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming;


import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;


/**
 * Defines methods used to access the partition name space.
 * The implementation classes that support partition naming 
 * system access should implement this interface.
 */
public interface Partitionable
{
   /**
    * Returns the root context of a partition naming system based
    * on a name string parameter.
    *
    * @param name The name string to look up.
    *
    * @return The root object of the partition naming system.
    *
    * @exception NamingException When a naming error occurs.
    */
   public Context getPartitionRoot (
         String name)
      throws NamingException;

   /**
    * Returns the root context of a partition naming system based
    * on a name object parameter.
    *
    * @param name  The name object to look up.
    *
    * @return The root object of the partition naming system.
    *
    * @exception NamingException When a naming error occurs.
    */
   public Context getPartitionRoot (
         Name name)
      throws NamingException;

   /**
    * Returns the associated partition context based on a
    * name string parameter.
    *
    * @param name The name string to look up.
    *
    * @return The associated DirContext object in the partition
    *         naming system.
    *
    * @exception NamingException When a naming error occurs.
    */
   public DirContext getPartition (
         String name)
      throws NamingException;

   /**
    * Returns the associated partition context based on a
    * name object parameter.
    *
    * @param name The name object to look up.
    *
    * @return The associated DirContext object in the partition
    *         naming system.
    *
    * @exception NamingException When a naming error occurs.
    */
   public DirContext getPartition (
         Name name)
      throws NamingException;

} /* Partitionable */


